/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValueCollection;
import org.eclipse.dltk.internal.javascript.ti.IValueParent;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.ReferenceKind;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionPath;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SimpleType;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.core.codeassist.CompletionVisitor;
import org.eclipse.dltk.javascript.internal.core.codeassist.JSCompletionEngine;
import org.eclipse.dltk.javascript.internal.core.codeassist.NodeFinder;
import org.eclipse.dltk.javascript.internal.core.codeassist.PositionCalculator;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

public class JavaScriptCompletionEngine2
extends ScriptCompletionEngine
implements JSCompletionEngine {
    private boolean useEngine = true;

    public boolean isUseEngine() {
        return this.useEngine;
    }

    public void setUseEngine(boolean useEngine) {
        this.useEngine = useEngine;
    }

    public void complete(final IModuleSource cu, int position, int i) {
        this.requestor.beginReporting();
        String content = cu.getSourceContents();
        if (position < 0 || position > content.length()) {
            return;
        }
        if (position > 0) {
            if (content.charAt(position - 1) == '.') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            } else if (content.charAt(position - 1) == '=') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            }
        }
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        NodeFinder nodeFinder = new NodeFinder(content, position);
        Script script = new JavaScriptParser().parse((IModuleSource)new ModuleSource(content){

            public IModelElement getModelElement() {
                return cu.getModelElement();
            }
        }, null);
        org.eclipse.dltk.javascript.ast.Type typeNode = nodeFinder.locateType(script);
        if (typeNode != null) {
            String typePrefix = "";
            if (typeNode instanceof SimpleType) {
                typePrefix = typeNode.getName();
                if (nodeFinder.end >= typeNode.sourceStart() && nodeFinder.end < typeNode.sourceEnd()) {
                    typePrefix = typePrefix.substring(0, nodeFinder.end - typeNode.sourceStart());
                }
            }
            this.doCompletionOnType(inferencer2, typePrefix, position);
        } else {
            PositionCalculator calculator = new PositionCalculator(content, position, false);
            CompletionVisitor visitor = new CompletionVisitor(inferencer2, position);
            inferencer2.setVisitor(visitor);
            if (cu instanceof ISourceModule) {
                inferencer2.setModelElement((IModelElement)((ISourceModule)cu));
            }
            try {
                inferencer2.doInferencing(script);
            }
            catch (PositionReachedException positionReachedException) {}
            if (calculator.isMember()) {
                this.doCompletionOnMember(inferencer2, visitor.getCollection(), new CompletionPath(calculator.getCompletion()), position);
            } else {
                this.doGlobalCompletion(inferencer2, visitor.getCollection(), new CompletionPath(calculator.getCompletion()), position);
            }
        }
        this.requestor.endReporting();
    }

    private void doCompletionOnType(ITypeInferenceContext context, String typeNamePrefix, int position) {
        Set<String> typeNames = context.listTypes(typeNamePrefix);
        Reporter reporter = new Reporter(typeNamePrefix, position);
        for (String typeName : typeNames) {
            Type type = context.getType(typeName);
            if (type == null || !type.isVisible()) continue;
            reporter.reportTypeRef(type);
        }
    }

    private static boolean exists(IValueParent item) {
        if (item instanceof IValueReference) {
            return ((IValueReference)item).exists();
        }
        return true;
    }

    private void doCompletionOnMember(ITypeInferenceContext context, IValueCollection collection, CompletionPath path, int position) {
        IValueParent item = collection;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            if (path.isName(i)) {
                String segment = path.segment(i);
                item = "this".equals(segment) && item instanceof IValueCollection ? item.getThis() : item.getChild(segment);
                if (!JavaScriptCompletionEngine2.exists(item)) {
                    break;
                }
            } else if (path.isFunction(i)) {
                if (!JavaScriptCompletionEngine2.exists(item = item.getChild("()"))) {
                    break;
                }
            } else {
                assert (path.isArray(i));
                if (!JavaScriptCompletionEngine2.exists(item = item.getChild("[]"))) break;
            }
            ++i;
        }
        if (item != null && JavaScriptCompletionEngine2.exists(item) && !path.isEmpty()) {
            Reporter reporter = new Reporter(path.lastSegment(), position);
            reporter.report(item);
            if (item instanceof IValueCollection) {
                IValueParent coll = item;
                while ((coll = coll.getParent()) != null) {
                    reporter.report(coll);
                }
                Set<String> globals = context.listGlobals(path.lastSegment());
                for (String global : globals) {
                    Element element;
                    if (!reporter.canReport(global) || (element = context.resolve(global)) == null || !element.isVisible()) continue;
                    reporter.report(global, element);
                }
            }
        }
    }

    private void doGlobalCompletion(ITypeInferenceContext context, IValueCollection collection, CompletionPath path, int position) {
        this.doCompletionOnMember(context, collection, path, position);
        if (this.useEngine) {
            this.doCompletionOnKeyword(path.lastSegment(), position);
        }
    }

    private void doCompletionOnKeyword(String startPart, int position) {
        this.setSourceRange(position - startPart.length(), position);
        String[] keywords = JavaScriptKeywords.getJavaScriptKeywords();
        this.findKeywords(startPart.toCharArray(), keywords, true);
    }

    static class MethodKey {
        final String name;
        final String signature;

        public MethodKey(Method method) {
            this.name = method.getName();
            StringBuilder sb = new StringBuilder();
            for (Parameter parameter : method.getParameters()) {
                Type paramType = parameter.getType();
                if (paramType != null) {
                    sb.append(paramType.getName());
                }
                sb.append(',');
            }
            this.signature = sb.toString();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey other = (MethodKey)obj;
                return this.name.equals(other.name) && this.signature.equals(other.signature);
            }
            return false;
        }

        protected static Object createKey(Member member) {
            if (member instanceof Method) {
                return new MethodKey((Method)member);
            }
            return member.getName();
        }
    }

    private class Reporter {
        final char[] prefix;
        final int position;
        final Set<Object> processed = new HashSet<Object>();
        final Set<Type> processedTypes = new HashSet<Type>();

        public Reporter(String prefix, int position) {
            this.prefix = prefix.toCharArray();
            this.position = position;
            JavaScriptCompletionEngine2.this.setSourceRange(position - this.prefix.length, position);
        }

        public void report(String name, Element element) {
            if (element instanceof Member && this.processed.add(name)) {
                this.reportMember((Member)element, name);
            }
        }

        public boolean canReport(String name) {
            return CharOperation.prefixEquals((char[])this.prefix, (String)name, (boolean)false) && !this.processed.contains(name);
        }

        public void report(IValueParent item) {
            Set<String> deleted = item.getDeletedChildren();
            for (String childName : item.getDirectChildren()) {
                IValueReference child;
                if (deleted.contains(childName) || !CharOperation.prefixEquals((char[])this.prefix, (String)childName, (boolean)false) || !this.processed.add(childName) || !(child = item.getChild(childName)).exists()) continue;
                this.reportReference(child, this.prefix, this.position);
            }
            if (item instanceof IValueReference) {
                IValueReference valueRef = (IValueReference)item;
                for (Type type : valueRef.getDeclaredTypes()) {
                    this.reportTypeMembers(type);
                }
                for (Type type : valueRef.getTypes()) {
                    this.reportTypeMembers(type);
                }
            }
        }

        private void reportTypeMembers(Type type) {
            if (this.processedTypes.add(type)) {
                for (Member member : type.getMembers()) {
                    if (!member.isVisible() || !CharOperation.prefixEquals((char[])this.prefix, (String)member.getName(), (boolean)false) || !this.processed.add(MethodKey.createKey(member))) continue;
                    this.reportMember(member, member.getName());
                }
            }
        }

        private void reportMember(Member member, String memberName) {
            Method method;
            int paramCount;
            boolean isFunction = member instanceof Method;
            CompletionProposal proposal = CompletionProposal.create((int)(isFunction ? 5 : 1), (int)this.position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, memberName);
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(memberName);
            proposal.setName(memberName);
            proposal.setExtraInfo((Object)member);
            proposal.setReplaceRange(JavaScriptCompletionEngine2.this.startPosition - JavaScriptCompletionEngine2.this.offset, JavaScriptCompletionEngine2.this.endPosition - JavaScriptCompletionEngine2.this.offset);
            if (isFunction && (paramCount = (method = (Method)member).getParameters().size()) > 0) {
                String[] params = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    params[i] = ((Parameter)method.getParameters().get(i)).getName();
                    ++i;
                }
                proposal.setParameterNames(params);
            }
            JavaScriptCompletionEngine2.this.requestor.accept(proposal);
        }

        private void reportReference(IValueReference reference, char[] prefix, int position) {
            int paramCount;
            IModelBuilder.IMethod method;
            boolean isFunction = reference.getKind() == ReferenceKind.FUNCTION || reference.getChild("()").exists();
            CompletionProposal proposal = CompletionProposal.create((int)(isFunction ? 5 : 4), (int)position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForInterestingProposal();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(prefix, reference.getName());
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(reference.getName());
            proposal.setName(reference.getName());
            proposal.setExtraInfo((Object)reference);
            proposal.setReplaceRange(JavaScriptCompletionEngine2.this.startPosition - JavaScriptCompletionEngine2.this.offset, JavaScriptCompletionEngine2.this.endPosition - JavaScriptCompletionEngine2.this.offset);
            if (isFunction && (method = (IModelBuilder.IMethod)reference.getAttribute("PARAMETERS")) != null && (paramCount = method.getParameterCount()) > 0) {
                String[] params = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    params[i] = method.getParameters().get(i).getName();
                    ++i;
                }
                proposal.setParameterNames(params);
            }
            JavaScriptCompletionEngine2.this.requestor.accept(proposal);
        }

        public void reportTypeRef(Type type) {
            CompletionProposal proposal = CompletionProposal.create((int)7, (int)this.position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, type.getName());
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(type.getName());
            proposal.setName(type.getName());
            proposal.setExtraInfo((Object)type);
            proposal.setReplaceRange(JavaScriptCompletionEngine2.this.startPosition - JavaScriptCompletionEngine2.this.offset, JavaScriptCompletionEngine2.this.endPosition - JavaScriptCompletionEngine2.this.offset);
            JavaScriptCompletionEngine2.this.requestor.accept(proposal);
        }
    }
}

