/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.SimpleLookupTable;
import org.eclipse.dltk.internal.core.builder.ScriptBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    final String scriptProjectName;
    int buildNumber;
    long lastStructuralBuildTime;
    SimpleLookupTable structuralBuildTimes;
    public static final byte VERSION = 23;
    Set<IPath> externalFolderLocations = new HashSet<IPath>();
    boolean noCleanExternalFolders = false;
    private final Map<IPath, Set<IPath>> dependencies = new HashMap<IPath, Set<IPath>>();
    private final Set<IPath> importProblems = new HashSet<IPath>();
    static final byte SOURCE_FOLDER = 1;
    static final byte BINARY_FOLDER = 2;
    static final byte EXTERNAL_JAR = 3;
    static final byte INTERNAL_JAR = 4;

    private State(String projectName) {
        this.scriptProjectName = projectName;
    }

    public State(IProject project) {
        this.scriptProjectName = project.getName();
        this.buildNumber = 0;
        this.lastStructuralBuildTime = System.currentTimeMillis();
        this.structuralBuildTimes = new SimpleLookupTable(3);
        this.noCleanExternalFolders = false;
    }

    protected State(ScriptBuilder scriptBuilder) {
        this.scriptProjectName = scriptBuilder.currentProject.getName();
        this.buildNumber = 0;
        this.lastStructuralBuildTime = System.currentTimeMillis();
        this.structuralBuildTimes = new SimpleLookupTable(3);
        this.noCleanExternalFolders = false;
    }

    void copyFrom(State lastState) {
        this.buildNumber = lastState.buildNumber + 1;
        this.lastStructuralBuildTime = lastState.lastStructuralBuildTime;
        this.structuralBuildTimes = lastState.structuralBuildTimes;
        this.externalFolderLocations.clear();
        this.externalFolderLocations.addAll(lastState.externalFolderLocations);
        this.noCleanExternalFolders = false;
        this.dependencies.clear();
        this.dependencies.putAll(lastState.dependencies);
        this.importProblems.clear();
        this.importProblems.addAll(lastState.importProblems);
    }

    public Set<IPath> getExternalFolders() {
        return this.externalFolderLocations;
    }

    static State read(IProject project, DataInputStream in) throws IOException {
        if (ScriptBuilder.DEBUG) {
            System.out.println("About to read state " + project.getName());
        }
        if (23 != in.readByte()) {
            if (ScriptBuilder.DEBUG) {
                System.out.println("Found non-compatible state version... answered null for " + project.getName());
            }
            return null;
        }
        State newState = new State(in.readUTF());
        if (!project.getName().equals(newState.scriptProjectName)) {
            if (ScriptBuilder.DEBUG) {
                System.out.println("Project's name does not match... answered null");
            }
            return null;
        }
        newState.buildNumber = in.readInt();
        newState.lastStructuralBuildTime = in.readLong();
        int length = in.readInt();
        newState.externalFolderLocations.clear();
        int i = 0;
        while (i < length) {
            String folderName = in.readUTF();
            if (folderName.length() > 0) {
                newState.externalFolderLocations.add(Path.fromPortableString((String)folderName));
            }
            ++i;
        }
        newState.noCleanExternalFolders = in.readBoolean();
        int dependencyCount = in.readInt();
        newState.dependencies.clear();
        int i2 = 0;
        while (i2 < dependencyCount) {
            HashSet<IPath> paths = new HashSet<IPath>();
            newState.dependencies.put(Path.fromOSString((String)in.readUTF()), paths);
            State.readPaths(in, paths);
            ++i2;
        }
        newState.importProblems.clear();
        State.readPaths(in, newState.importProblems);
        if (ScriptBuilder.DEBUG) {
            System.out.println("Successfully read state for " + newState.scriptProjectName);
        }
        return newState;
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    boolean wasStructurallyChanged(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqProject.getName());
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeByte(23);
        out.writeUTF(this.scriptProjectName);
        out.writeInt(this.buildNumber);
        out.writeLong(this.lastStructuralBuildTime);
        out.writeInt(this.externalFolderLocations.size());
        for (IPath path : this.externalFolderLocations) {
            out.writeUTF(path.toPortableString());
        }
        out.writeBoolean(this.noCleanExternalFolders);
        out.writeInt(this.dependencies.size());
        for (Map.Entry<IPath, Set<IPath>> entry : this.dependencies.entrySet()) {
            out.writeUTF(entry.getKey().toPortableString());
            this.writePaths(out, (Collection<IPath>)entry.getValue());
        }
        this.writePaths(out, this.importProblems);
    }

    private static void readPaths(DataInputStream in, Collection<IPath> paths) throws IOException {
        int pathCount = in.readInt();
        int j = 0;
        while (j < pathCount) {
            paths.add(Path.fromPortableString((String)in.readUTF()));
            ++j;
        }
    }

    private void writePaths(DataOutputStream out, Collection<IPath> paths) throws IOException {
        out.writeInt(paths.size());
        for (IPath path : paths) {
            out.writeUTF(path.toPortableString());
        }
    }

    public String toString() {
        return "State for " + this.scriptProjectName + " (#" + this.buildNumber + " @ " + new Date(this.lastStructuralBuildTime) + ")";
    }

    public void setNoCleanExternalFolders() {
        this.noCleanExternalFolders = true;
    }

    protected void recordImportProblem(IPath path) {
        Assert.isLegal((boolean)this.scriptProjectName.equals(path.segment(0)));
        this.importProblems.add(path);
    }

    protected void recordDependency(IPath path, IPath dependency) {
        Assert.isLegal((boolean)this.scriptProjectName.equals(path.segment(0)));
        Assert.isLegal((!path.equals((Object)dependency) ? 1 : 0) != 0);
        Set<IPath> paths = this.dependencies.get(dependency);
        if (paths == null) {
            paths = new HashSet<IPath>();
            this.dependencies.put(dependency, paths);
        }
        paths.add(path);
    }

    protected void resetDependencies() {
        this.dependencies.clear();
        this.importProblems.clear();
    }

    protected void removeDependenciesFor(Set<IPath> paths) {
        Iterator<Map.Entry<IPath, Set<IPath>>> i = this.dependencies.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IPath, Set<IPath>> entry = i.next();
            if (!entry.getValue().removeAll(paths) || !entry.getValue().isEmpty()) continue;
            i.remove();
        }
        this.importProblems.removeAll(paths);
    }

    protected Collection<IPath> dependenciesOf(Collection<IPath> paths, boolean includeImportProblems) {
        ArrayList<IPath> result = new ArrayList<IPath>();
        if (includeImportProblems) {
            result.addAll(this.importProblems);
        }
        for (IPath path : paths) {
            Set<IPath> deps = this.dependencies.get(path);
            if (deps == null) continue;
            result.addAll(deps);
        }
        return result;
    }

    protected Collection<IPath> allDependenciesOf(Collection<IPath> paths) {
        HashSet<IPath> result = new HashSet<IPath>();
        ArrayList<IPath> queue = new ArrayList<IPath>();
        while (!paths.isEmpty()) {
            result.addAll(paths);
            for (IPath path : paths) {
                Set<IPath> deps = this.dependencies.get(path);
                if (deps == null) continue;
                queue.addAll(deps);
            }
            queue.removeAll(result);
            paths.clear();
            paths.addAll(queue);
            queue.clear();
        }
        return result;
    }
}

