/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldPredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;
    private final ISourceModule module;
    private final int nameStart;
    private final int nameEnd;

    public FieldPredicate(FieldPattern pattern) {
        super((SearchPattern)pattern, pattern.name);
        this.declarations = pattern.findDeclarations;
        this.references = pattern.findReferences;
        ISourceRange nameRange = null;
        if (pattern.focus instanceof IMember) {
            try {
                nameRange = ((IMember)pattern.focus).getNameRange();
            }
            catch (ModelException modelException) {}
        }
        if (nameRange != null) {
            this.nameStart = nameRange.getOffset();
            this.nameEnd = this.nameStart + nameRange.getLength();
            this.module = pattern.focus != null ? (ISourceModule)pattern.focus.getAncestor(5) : null;
        } else {
            this.nameStart = -1;
            this.nameEnd = -1;
            this.module = null;
        }
    }

    public MatchLevel match(MatchingNode node) {
        if (node instanceof FieldDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            FieldDeclarationNode fieldNode = (FieldDeclarationNode)node;
            return this.matchName(fieldNode.getName());
        }
        if (node instanceof FieldReferenceNode) {
            if (!this.references) {
                return null;
            }
            FieldReferenceNode fieldNode = (FieldReferenceNode)node;
            ReferenceLocation location = fieldNode.getReferenceLocation();
            if (location != null && this.nameStart != -1 && this.nameEnd != -1) {
                if (location.getNameStart() == this.nameStart && location.getNameEnd() == this.nameEnd && this.isSame(location.getSourceModule())) {
                    return this.matchName(((Identifier)fieldNode.node).getName());
                }
            } else {
                return this.matchName(((Identifier)fieldNode.node).getName());
            }
        }
        return null;
    }

    private boolean isSame(ISourceModule module) {
        return module != null && module.equals(this.module);
    }
}

