/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;

public final class DestinationContentProvider
extends StandardModelElementContentProvider {
    private IReorgDestinationValidator fValidator;

    public DestinationContentProvider(IReorgDestinationValidator validator) {
        super(true);
        this.fValidator = validator;
    }

    public boolean hasChildren(Object element) {
        IResource resource;
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            if (!this.fValidator.canChildrenBeDestinations(modelElement)) {
                return false;
            }
            if (modelElement.getElementType() == 3 && ((IProjectFragment)modelElement).isArchive()) {
                return false;
            }
        } else if (element instanceof IResource && !this.fValidator.canChildrenBeDestinations(resource = (IResource)element)) {
            return false;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IScriptModel) {
                return DestinationContentProvider.concatenate(this.getScriptProjects((IScriptModel)parentElement), DestinationContentProvider.getOpenNonScriptProjects((IScriptModel)parentElement));
            }
            Object[] children = super.getChildren(parentElement);
            ArrayList<Object> result = new ArrayList<Object>(children.length);
            int i = 0;
            while (i < children.length) {
                IResource resource;
                if (children[i] instanceof IModelElement) {
                    IModelElement modelElement = (IModelElement)children[i];
                    if (this.fValidator.canElementBeDestination(modelElement) || this.fValidator.canChildrenBeDestinations(modelElement)) {
                        result.add(modelElement);
                    }
                } else if (children[i] instanceof IResource && (this.fValidator.canElementBeDestination(resource = (IResource)children[i]) || this.fValidator.canChildrenBeDestinations(resource))) {
                    result.add(resource);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
            return new Object[0];
        }
    }

    private static Object[] getOpenNonScriptProjects(IScriptModel model) throws ModelException {
        Object[] nonScriptProjects = model.getForeignResources();
        ArrayList<IProject> result = new ArrayList<IProject>(nonScriptProjects.length);
        int i = 0;
        while (i < nonScriptProjects.length) {
            IProject project = (IProject)nonScriptProjects[i];
            if (project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }
}

