/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptCompletionProposalComputer
implements IScriptCompletionProposalComputer {
    private String fErrorMessage;

    private List<IContextInformation> addContextInformations(ScriptContentAssistInvocationContext context, int offset, IProgressMonitor monitor) {
        List<ICompletionProposal> proposals = this.computeScriptCompletionProposals(offset, context, monitor);
        ArrayList<IContextInformation> result = new ArrayList<IContextInformation>(proposals.size());
        for (ICompletionProposal proposal : proposals) {
            IContextInformation contextInformation = proposal.getContextInformation();
            if (contextInformation == null) continue;
            ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
            wrapper.setContextInformationPosition(offset);
            result.add(wrapper);
        }
        return result;
    }

    private void handleCodeCompletionException(ModelException e, ScriptContentAssistInvocationContext context) {
        ISourceModule module = context.getSourceModule();
        Shell shell = context.getViewer().getTextWidget().getShell();
        if (e.isDoesNotExist() && !module.getScriptProject().isOnBuildpath((IModelElement)module)) {
            IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
            boolean value = store.getBoolean("org.eclipse.dltk.ui.notification.not_on_buildpath");
            if (!value) {
                MessageDialog.openInformation((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            store.setValue("org.eclipse.dltk.ui.notification.not_on_buildpath", true);
        } else {
            ErrorDialog.openError((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_accessing_title, (String)ScriptTextMessages.CompletionProcessor_error_accessing_message, (IStatus)e.getStatus());
        }
    }

    protected List<ICompletionProposal> computeTemplateCompletionProposals(int offset, ScriptContentAssistInvocationContext context, IProgressMonitor monitor) {
        TemplateCompletionProcessor templateProcessor = this.createTemplateProposalComputer(context);
        if (templateProcessor != null) {
            ICompletionProposal[] proposals = templateProcessor.computeCompletionProposals(context.getViewer(), offset);
            if (proposals != null && proposals.length != 0) {
                this.updateTemplateProposalRelevance(context, proposals);
            }
            return Arrays.asList(proposals);
        }
        return Collections.emptyList();
    }

    protected void updateTemplateProposalRelevance(ScriptContentAssistInvocationContext context, ICompletionProposal[] proposals) {
        IScriptCompletionProposal[] keywords = context.getKeywordProposals();
        if (keywords == null || keywords.length == 0) {
            return;
        }
        int i = 0;
        while (i < proposals.length) {
            ICompletionProposal cp = proposals[i];
            if (cp instanceof ScriptTemplateProposal) {
                ScriptTemplateProposal tp = (ScriptTemplateProposal)cp;
                String name = tp.getPattern();
                int j = 0;
                while (j < keywords.length) {
                    if (name.startsWith(keywords[j].getDisplayString())) {
                        tp.setRelevance(keywords[j].getRelevance());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected List<ICompletionProposal> computeScriptCompletionProposals(int offset, ScriptContentAssistInvocationContext context, IProgressMonitor monitor) {
        ISourceModule sourceModule = context.getSourceModule();
        if (sourceModule == null) {
            return Collections.emptyList();
        }
        ScriptCompletionProposalCollector collector = this.createCollector(context);
        if (collector == null) {
            return Collections.emptyList();
        }
        collector.setInvocationContext(context);
        Point selection = context.getViewer().getSelectedRange();
        if (selection.y > 0) {
            collector.setReplacementLength(selection.y);
        }
        try {
            IModelElement element;
            if (DLTKCore.DEBUG_COMPLETION && (element = sourceModule.getElementAt(offset)) != null) {
                System.out.println("========= Model element: " + element.getClass());
            }
            int timeout = DLTKUIPlugin.getDefault().getPreferenceStore().getInt("content_assist_timeout");
            sourceModule.codeComplete(offset, (CompletionRequestor)collector, (long)timeout);
        }
        catch (ModelException e) {
            this.handleCodeCompletionException(e, context);
        }
        IScriptCompletionProposal[] proposals = collector.getScriptCompletionProposals();
        if (proposals.length == 0) {
            String error = collector.getErrorMessage();
            if (error != null && error.length() > 0) {
                this.fErrorMessage = error;
            }
            return Collections.emptyList();
        }
        return Arrays.asList(proposals);
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof ScriptContentAssistInvocationContext) {
            ScriptContentAssistInvocationContext scriptContext = (ScriptContentAssistInvocationContext)context;
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            proposals.addAll(this.computeScriptCompletionProposals(context.getInvocationOffset(), scriptContext, monitor));
            proposals.addAll(this.computeTemplateCompletionProposals(context.getInvocationOffset(), scriptContext, monitor));
            return proposals;
        }
        return Collections.emptyList();
    }

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        return context.getInvocationOffset();
    }

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof ScriptContentAssistInvocationContext) {
            ScriptContentAssistInvocationContext scriptContext = (ScriptContentAssistInvocationContext)context;
            int contextInformationPosition = this.guessContextInformationPosition(scriptContext);
            List<IContextInformation> result = this.addContextInformations(scriptContext, contextInformationPosition, monitor);
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    protected abstract TemplateCompletionProcessor createTemplateProposalComputer(ScriptContentAssistInvocationContext var1);

    protected abstract ScriptCompletionProposalCollector createCollector(ScriptContentAssistInvocationContext var1);

    private static final class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }
    }
}

