/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.folding;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.folding.AbortFoldingException;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockRequestor;
import org.eclipse.dltk.ui.text.folding.IFoldingContent;
import org.eclipse.jface.preference.IPreferenceStore;

public class ModelFoldingBlockProvider
implements IFoldingBlockProvider,
IModelElementVisitor {
    private IFoldingBlockRequestor requestor;

    public void initializePreferences(IPreferenceStore preferenceStore) {
    }

    public void setRequestor(IFoldingBlockRequestor requestor) {
        this.requestor = requestor;
    }

    public int getMinimalLineCount() {
        return 0;
    }

    public void computeFoldableBlocks(IFoldingContent content) {
        try {
            content.getModelElement().accept((IModelElementVisitor)this);
        }
        catch (ModelException e) {
            this.abortFolding(e);
        }
    }

    private void abortFolding(ModelException e) {
        if (!e.isDoesNotExist()) {
            DLTKUIPlugin.logErrorMessage("Error when computing folding", e);
        }
        throw new AbortFoldingException();
    }

    public boolean visit(IModelElement element) {
        if (element instanceof IType || element instanceof IMember) {
            this.reportElement(element);
        }
        return true;
    }

    protected void reportElement(IModelElement element) {
        if (!(element instanceof ISourceReference)) {
            return;
        }
        try {
            ISourceRange range = ((ISourceReference)element).getSourceRange();
            if (SourceRange.isAvailable((ISourceRange)range) && range.getLength() > 0) {
                this.requestor.acceptBlock(range.getOffset(), range.getOffset() + range.getLength(), this.getKind(element), element, this.isFoldedInitially(element));
            }
        }
        catch (ModelException e) {
            this.abortFolding(e);
        }
    }

    protected boolean isFoldedInitially(IModelElement element) {
        return false;
    }

    protected IFoldingBlockKind getKind(IModelElement element) {
        return element.getElementType() == 7 ? FoldingBlockKind.TYPE : FoldingBlockKind.METHOD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FoldingBlockKind implements IFoldingBlockKind
    {
        TYPE,
        METHOD;


        @Override
        public boolean isComment() {
            return false;
        }
    }
}

