/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.actions.FindAction;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;

public class FindReferencesAction
extends FindAction {
    public FindReferencesAction(IDLTKLanguageToolkit toolkit, IWorkbenchSite site) {
        super(toolkit, site);
    }

    public FindReferencesAction(IDLTKLanguageToolkit toolkit, ScriptEditor editor) {
        super(toolkit, editor);
    }

    @Override
    Class[] getValidTypes() {
        return new Class[]{ISourceModule.class, IType.class, IMethod.class, IField.class, IPackageDeclaration.class, IScriptFolder.class, ILocalVariable.class};
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_REF);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help support here...");
        }
    }

    @Override
    int getLimitTo() {
        return 1;
    }

    @Override
    QuerySpecification createQuery(IModelElement element) throws ModelException {
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        boolean isInsideInterpreterEnvironment = factory.isInsideInterpreter(element);
        IDLTKSearchScope scope = factory.createWorkspaceScope(isInsideInterpreterEnvironment, this.getLanguageToolkit());
        String description = factory.getWorkspaceScopeDescription(isInsideInterpreterEnvironment);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }

    @Override
    public void run(IModelElement element) {
        super.run(element);
    }
}

