/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.coloring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.ui.coloring.AbstractColoringPreferenceRequestor;
import org.eclipse.dltk.ui.coloring.EnablementStyle;
import org.eclipse.dltk.ui.coloring.FontStyle;
import org.eclipse.dltk.ui.coloring.IColoringCategoryConstants;
import org.eclipse.dltk.ui.coloring.IColoringPreferenceKey;
import org.eclipse.swt.graphics.RGB;

public class ColoringConfigurationModelCollector
extends AbstractColoringPreferenceRequestor
implements IColoringCategoryConstants {
    private String category = sCoreCategory;
    private final List<Item> entries = new ArrayList<Item>();

    @Override
    public void enterCategory(String category) {
        this.category = category;
    }

    @Override
    public void addPreference(IColoringPreferenceKey key, String name, RGB color, EnablementStyle enablementStyle, FontStyle ... fontStyles) {
        this.entries.add(new Item(name, key.getColorKey(), this.category, enablementStyle));
    }

    public String[][] getColorListModel() {
        String[][] result = new String[this.entries.size()][];
        int i = 0;
        while (i < this.entries.size()) {
            Item entry = this.entries.get(i);
            result[i] = new String[entry.canEnable() ? 4 : 3];
            result[i][0] = entry.name;
            result[i][1] = entry.key;
            result[i][2] = entry.category;
            if (entry.canEnable()) {
                result[i][3] = entry.enablementStyle.name();
            }
            ++i;
        }
        return result;
    }

    private static class Item {
        final String name;
        final String key;
        final String category;
        final EnablementStyle enablementStyle;

        public Item(String name, String key, String category, EnablementStyle enablementStyle) {
            this.name = name;
            this.key = key;
            this.category = category;
            this.enablementStyle = enablementStyle;
        }

        boolean canEnable() {
            return this.enablementStyle != EnablementStyle.ALWAYS_ON;
        }
    }
}

