/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.AddSelectedSourceFolderOperation;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.CreateFolderOperation;
import org.eclipse.dltk.internal.corext.buildpath.EditFiltersOperation;
import org.eclipse.dltk.internal.corext.buildpath.ExcludeOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.corext.buildpath.IPackageExplorerActionListener;
import org.eclipse.dltk.internal.corext.buildpath.LinkedSourceFolderOperation;
import org.eclipse.dltk.internal.corext.buildpath.PackageExplorerActionEvent;
import org.eclipse.dltk.internal.corext.buildpath.RemoveFromBuildpathOperation;
import org.eclipse.dltk.internal.corext.buildpath.ResetAllOperation;
import org.eclipse.dltk.internal.corext.buildpath.UnexcludeOperation;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.util.ViewerPane;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierAction;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierDropDownAction;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionContext;

public class DialogPackageExplorerActionGroup
extends CompositeActionGroup {
    public static final int SCRIPT_PROJECT = 1;
    public static final int PACKAGE_FRAGMENT_ROOT = 2;
    public static final int PACKAGE_FRAGMENT = 3;
    public static final int SOURCE_MODULE = 4;
    public static final int FILE = 5;
    public static final int FOLDER = 6;
    public static final int EXCLUDED_FOLDER = 7;
    public static final int EXCLUDED_FILE = 8;
    public static final int INCLUDED_FILE = 10;
    public static final int INCLUDED_FOLDER = 11;
    public static final int ARCHIVE = 13;
    public static final int MODIFIED_FRAGMENT_ROOT = 14;
    public static final int DEFAULT_FRAGMENT = 15;
    public static final int UNDEFINED = 16;
    public static final int MULTI = 17;
    public static final int NULL_SELECTION = 18;
    public static final int ARCHIVE_RESOURCE = 19;
    public static final int EXTERNAL_RESOURCE = 21;
    public static final int CONTAINER = 20;
    private BuildpathModifierAction[] fActions;
    private int fLastType = 16;
    private List fListeners = new ArrayList();
    private static final int fContextSensitiveActions = 5;

    public DialogPackageExplorerActionGroup(IBuildpathInformationProvider provider, BuildpathModifier.IBuildpathModifierListener listener) {
        this.fActions = new BuildpathModifierAction[8];
        BuildpathModifierOperation op = new AddSelectedSourceFolderOperation(listener, provider);
        this.addAction(new BuildpathModifierAction(op, DLTKPluginImages.DESC_ELCL_ADD_AS_SOURCE_FOLDER, null, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip, 1), 0);
        op = new RemoveFromBuildpathOperation(listener, provider);
        this.addAction(new BuildpathModifierAction(op, DLTKPluginImages.DESC_ELCL_REMOVE_AS_SOURCE_FOLDER, DLTKPluginImages.DESC_DLCL_REMOVE_AS_SOURCE_FOLDER, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip, 1), 1);
        op = new ExcludeOperation(listener, provider);
        this.addAction(new BuildpathModifierAction(op, DLTKPluginImages.DESC_ELCL_EXCLUDE_FROM_BUILDPATH, DLTKPluginImages.DESC_DLCL_EXCLUDE_FROM_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip, 1), 2);
        op = new UnexcludeOperation(listener, provider);
        this.addAction(new BuildpathModifierAction(op, DLTKPluginImages.DESC_ELCL_INCLUDE_ON_BUILDPATH, DLTKPluginImages.DESC_DLCL_INCLUDE_ON_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip, 1), 3);
        op = new EditFiltersOperation(listener, provider);
        BuildpathModifierAction action = new BuildpathModifierAction(op, DLTKPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS, DLTKPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip, 1);
        BuildpathModifierDropDownAction dropDown = new BuildpathModifierDropDownAction(action, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Configure_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Configure_tooltip);
        this.addAction(dropDown, 4);
        op = new LinkedSourceFolderOperation(listener, provider);
        this.addAction(new BuildpathModifierAction(op, DLTKPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH, DLTKPluginImages.DESC_DLCL_ADD_LINKED_SOURCE_TO_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip, 1), 5);
        op = new CreateFolderOperation(listener, provider);
        this.addAction(new BuildpathModifierAction(op, DLTKPluginImages.DESC_OBJS_PACKFRAG_ROOT, null, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_CreateSrcFolder_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_CreateSrcFolder_tooltip, 1), 6);
        op = new ResetAllOperation(listener, provider);
        this.addAction(new BuildpathModifierAction(op, DLTKPluginImages.DESC_ELCL_CLEAR, DLTKPluginImages.DESC_DLCL_CLEAR, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip, 1), 7);
    }

    private void addAction(BuildpathModifierAction action, int index) {
        this.fActions[index] = action;
    }

    public BuildpathModifierAction getAction(int type) {
        int i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i].getOperation().getTypeId() == type) {
                return this.fActions[i];
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BuildpathModifierAction[] getActions() {
        ArrayList<BuildpathModifierAction> result = new ArrayList<BuildpathModifierAction>();
        int i = 0;
        while (i < this.fActions.length) {
            BuildpathModifierAction action = this.fActions[i];
            if (action instanceof BuildpathModifierDropDownAction) {
                BuildpathModifierDropDownAction dropDownAction = (BuildpathModifierDropDownAction)action;
                BuildpathModifierAction[] actions = dropDownAction.getActions();
                int j = 0;
                while (j < actions.length) {
                    result.add(actions[j]);
                    ++j;
                }
            } else {
                result.add(action);
            }
            ++i;
        }
        return result.toArray(new BuildpathModifierAction[result.size()]);
    }

    public ToolBarManager createLeftToolBarManager(ViewerPane pane) {
        ToolBarManager tbm = pane.getToolBarManager();
        int i = 0;
        while (i < 5) {
            tbm.add((IAction)this.fActions[i]);
            if (i == 1 || i == 3) {
                tbm.add((IContributionItem)new Separator());
            }
            ++i;
        }
        tbm.update(true);
        return tbm;
    }

    public ToolBarManager createLeftToolBar(ViewerPane pane) {
        ToolBar tb = new ToolBar((Composite)pane, 0x800000);
        pane.setTopRight((Control)tb);
        ToolBarManager tbm = new ToolBarManager(tb);
        int i = 5;
        while (i < this.fActions.length) {
            tbm.add((IAction)this.fActions[i]);
            ++i;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        tbm.update(true);
        return tbm;
    }

    public void refresh(DialogExplorerActionContext context) throws ModelException {
        super.setContext(context);
        if (context == null) {
            return;
        }
        List selectedElements = context.getSelectedElements();
        IScriptProject project = context.getScriptProject();
        int type = 17;
        if (selectedElements.size() == 0) {
            type = 18;
            if (type == this.fLastType) {
                return;
            }
        } else if (selectedElements.size() == 1 || this.identicalTypes(selectedElements, project)) {
            type = DialogPackageExplorerActionGroup.getType(selectedElements.get(0), project);
        }
        this.internalSetContext(selectedElements, project, type);
    }

    @Override
    public void setContext(ActionContext context) {
        try {
            this.setContext((DialogExplorerActionContext)context);
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
    }

    public void setContext(DialogExplorerActionContext context) throws ModelException {
        super.setContext(context);
        if (context == null) {
            return;
        }
        List selectedElements = context.getSelectedElements();
        IScriptProject project = context.getScriptProject();
        int type = 17;
        if (selectedElements.size() == 0) {
            type = 18;
            if (type == this.fLastType) {
                return;
            }
        } else if (selectedElements.size() == 1 || this.identicalTypes(selectedElements, project)) {
            type = DialogPackageExplorerActionGroup.getType(selectedElements.get(0), project);
            if (selectedElements.size() > 1) {
                type |= 0x11;
            }
            if (type == this.fLastType) {
                return;
            }
        }
        this.internalSetContext(selectedElements, project, type);
    }

    public String getNoActionDescription() {
        String[] description = this.noAction(this.fLastType);
        return description[0];
    }

    private void internalSetContext(List selectedElements, IScriptProject project, int type) throws ModelException {
        this.fLastType = type;
        List availableActions = this.getAvailableActions(selectedElements, project);
        BuildpathModifierAction[] actions = new BuildpathModifierAction[availableActions.size()];
        String[] descriptions = new String[availableActions.size()];
        if (availableActions.size() > 0) {
            int i = 0;
            while (i < availableActions.size()) {
                BuildpathModifierAction action;
                actions[i] = action = (BuildpathModifierAction)((Object)availableActions.get(i));
                descriptions[i] = action.getDescription(type);
                ++i;
            }
        } else {
            descriptions = this.noAction(type);
        }
        this.informListeners(descriptions, actions);
    }

    private boolean identicalTypes(List elements, IScriptProject project) throws ModelException {
        if (elements.size() == 0) {
            return false;
        }
        Object firstElement = elements.get(0);
        int firstType = DialogPackageExplorerActionGroup.getType(firstElement, project);
        int i = 1;
        while (i < elements.size()) {
            if (firstType != DialogPackageExplorerActionGroup.getType(elements.get(i), project)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void informListeners(String[] descriptions, BuildpathModifierAction[] actions) {
        Iterator iterator = this.fListeners.iterator();
        PackageExplorerActionEvent event = new PackageExplorerActionEvent(descriptions, actions);
        while (iterator.hasNext()) {
            IPackageExplorerActionListener listener = (IPackageExplorerActionListener)iterator.next();
            listener.handlePackageExplorerActionEvent(event);
        }
    }

    private String[] noAction(int type) {
        String reason;
        switch (type) {
            case 5: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_File;
                break;
            }
            case 21: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_File;
                break;
            }
            case 15: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_DefaultPackage;
                break;
            }
            case 31: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_DefaultPackage;
                break;
            }
            case 18: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_NullSelection;
                break;
            }
            case 17: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_MultiSelection;
                break;
            }
            case 19: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_ArchiveResource;
                break;
            }
            default: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_NoReason;
            }
        }
        return new String[]{reason};
    }

    public static int getType(Object obj, IScriptProject project) throws ModelException {
        if (obj instanceof IScriptProject) {
            return 1;
        }
        if (obj instanceof BuildPathContainer) {
            return 20;
        }
        if (obj instanceof IProjectFragment) {
            return BuildpathModifier.filtersSet((IProjectFragment)obj) ? 14 : 2;
        }
        if (obj instanceof IScriptFolder) {
            if (BuildpathModifier.isDefaultFragment((IScriptFolder)obj)) {
                if (((IProjectFragment)((IModelElement)obj).getAncestor(3)).isArchive()) {
                    return 19;
                }
                return 15;
            }
            if (BuildpathModifier.isIncluded((IModelElement)obj, project, null)) {
                return 11;
            }
            if (((IProjectFragment)((IModelElement)obj).getAncestor(3)).isArchive()) {
                return 19;
            }
            if (((IProjectFragment)((IModelElement)obj).getAncestor(3)).isExternal()) {
                return 21;
            }
            return 3;
        }
        if (obj instanceof ISourceModule) {
            if (((IProjectFragment)((IModelElement)obj).getAncestor(3)).isArchive()) {
                return 19;
            }
            if (((IProjectFragment)((IModelElement)obj).getAncestor(3)).isExternal()) {
                return 21;
            }
            return BuildpathModifier.isIncluded((IModelElement)obj, project, null) ? 10 : 4;
        }
        if (obj instanceof IFolder) {
            return DialogPackageExplorerActionGroup.getFolderType((IFolder)obj, project);
        }
        if (obj instanceof IFile) {
            return DialogPackageExplorerActionGroup.getFileType((IFile)obj, project);
        }
        return 16;
    }

    private static int getFolderType(IFolder folder, IScriptProject project) throws ModelException {
        IContainer folderParent = folder.getParent();
        if (folderParent.getFullPath().equals((Object)project.getPath())) {
            return 6;
        }
        if (BuildpathModifier.getFragment((IResource)folderParent) != null) {
            return 7;
        }
        IProjectFragment fragmentRoot = BuildpathModifier.getFragmentRoot((IResource)folder, project, null);
        if (fragmentRoot == null) {
            return 6;
        }
        if (fragmentRoot.equals(DLTKCore.create((IResource)folderParent))) {
            return 7;
        }
        return 6;
    }

    private static int getFileType(IFile file, IScriptProject project) throws ModelException {
        IContainer fileParent;
        if (BuildpathModifier.isArchive(file, project)) {
            return 13;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("DialogPackageExplorerActionGroup:: Add some filters here");
        }
        if ((fileParent = file.getParent()).getFullPath().equals((Object)project.getPath())) {
            if (project.isOnBuildpath((IModelElement)project)) {
                return 8;
            }
            return 5;
        }
        IProjectFragment fragmentRoot = BuildpathModifier.getFragmentRoot((IResource)file, project, null);
        if (fragmentRoot == null) {
            return 5;
        }
        if (fragmentRoot.isArchive()) {
            return 19;
        }
        if (fragmentRoot.equals(DLTKCore.create((IResource)fileParent))) {
            return 8;
        }
        if (BuildpathModifier.getFragment((IResource)fileParent) == null) {
            if (BuildpathModifier.parentExcluded((IResource)fileParent, project)) {
                return 5;
            }
            return 8;
        }
        return 8;
    }

    private List getAvailableActions(List selectedElements, IScriptProject project) throws ModelException {
        if (project == null || !project.exists()) {
            return new ArrayList();
        }
        ArrayList<BuildpathModifierAction> actions = new ArrayList<BuildpathModifierAction>();
        int[] types = new int[selectedElements.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = DialogPackageExplorerActionGroup.getType(selectedElements.get(i), project);
            ++i;
        }
        i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i] instanceof BuildpathModifierDropDownAction) {
                if (this.changeEnableState(this.fActions[i], selectedElements, types)) {
                    BuildpathModifierAction[] dropDownActions = ((BuildpathModifierDropDownAction)this.fActions[i]).getActions();
                    int j = 0;
                    while (j < dropDownActions.length) {
                        if (this.changeEnableState(dropDownActions[j], selectedElements, types)) {
                            actions.add(dropDownActions[j]);
                        }
                        ++j;
                    }
                }
            } else if (this.changeEnableState(this.fActions[i], selectedElements, types)) {
                actions.add(this.fActions[i]);
            }
            ++i;
        }
        return actions;
    }

    private boolean changeEnableState(BuildpathModifierAction action, List selectedElements, int[] types) throws ModelException {
        if (action.isValid(selectedElements, types)) {
            if (!action.isEnabled()) {
                action.setEnabled(true);
            }
            return true;
        }
        if (action.isEnabled()) {
            action.setEnabled(false);
        }
        return false;
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        int i = 0;
        while (i < 5) {
            BuildpathModifierAction action = this.getAction(i);
            if (action instanceof BuildpathModifierDropDownAction) {
                if (action.isEnabled()) {
                    BuildpathModifierAction[] actions = ((BuildpathModifierDropDownAction)action).getActions();
                    int j = 0;
                    while (j < actions.length) {
                        if (actions[j].isEnabled()) {
                            menu.add((IAction)actions[j]);
                        }
                        ++j;
                    }
                }
            } else if (action.isEnabled()) {
                menu.add((IAction)action);
            }
            ++i;
        }
        super.fillContextMenu(menu);
    }

    public void addListener(IPackageExplorerActionListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(IPackageExplorerActionListener listener) {
        this.fListeners.remove(listener);
    }

    @Override
    public void dispose() {
        this.fListeners.clear();
        super.dispose();
    }

    public static class DialogExplorerActionContext
    extends ActionContext {
        private IScriptProject fScriptProject;
        private List fSelectedElements;

        public DialogExplorerActionContext(ISelection selection, IScriptProject jProject) {
            super(null);
            this.fScriptProject = jProject;
            this.fSelectedElements = ((IStructuredSelection)selection).toList();
            StructuredSelection structuredSelection = new StructuredSelection(new Object[]{this.fSelectedElements, jProject});
            super.setSelection((ISelection)structuredSelection);
        }

        public DialogExplorerActionContext(List selectedElements, IScriptProject jProject) {
            super(null);
            this.fScriptProject = jProject;
            this.fSelectedElements = selectedElements;
            StructuredSelection structuredSelection = new StructuredSelection(new Object[]{this.fSelectedElements, jProject});
            super.setSelection((ISelection)structuredSelection);
        }

        public IScriptProject getScriptProject() {
            return this.fScriptProject;
        }

        public List getSelectedElements() {
            return this.fSelectedElements;
        }
    }
}

