/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingPart;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class ScriptBrowsingContentProvider
extends StandardModelElementContentProvider
implements IElementChangedListener {
    private StructuredViewer fViewer;
    private Object fInput;
    private ScriptBrowsingPart fBrowsingPart;
    private int fReadsInDisplayThread;
    private IDLTKLanguageToolkit fToolkit;

    public ScriptBrowsingContentProvider(boolean provideMembers, ScriptBrowsingPart browsingPart, IDLTKLanguageToolkit languageToolkit) {
        super(provideMembers);
        this.fBrowsingPart = browsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        DLTKCore.addElementChangedListener((IElementChangedListener)this);
        this.fToolkit = languageToolkit;
    }

    public IDLTKLanguageToolkit getToolkit() {
        return this.fToolkit;
    }

    @Override
    public boolean hasChildren(Object element) {
        this.startReadInDisplayThread();
        try {
            boolean bl = super.hasChildren(element);
            return bl;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    @Override
    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        this.startReadInDisplayThread();
        try {
            if (element instanceof Collection) {
                Collection elements = (Collection)element;
                if (elements.isEmpty()) {
                    Object[] objectArray = NO_CHILDREN;
                    return objectArray;
                }
                Object[] result = new Object[]{};
                Iterator iter = ((Collection)element).iterator();
                while (iter.hasNext()) {
                    Object[] children = this.getChildren(iter.next());
                    if (children == NO_CHILDREN) continue;
                    result = ScriptBrowsingContentProvider.concatenate(result, children);
                }
                Object[] objectArray = this.filterExternal(result);
                return objectArray;
            }
            if (element instanceof IScriptFolder) {
                Object[] objectArray = this.getScriptFolderContents((IScriptFolder)element);
                return objectArray;
            }
            if (this.fProvideMembers && element instanceof IType) {
                Object[] objectArray = this.getChildren((IType)element);
                return objectArray;
            }
            if (this.fProvideMembers && element instanceof ISourceReference && element instanceof IParent) {
                Object[] objectArray = this.removeImportAndPackageDeclarations(super.getChildren(element));
                return objectArray;
            }
            if (element instanceof IScriptProject) {
                Object[] objectArray = this.getProjectFragments((IScriptProject)element);
                return objectArray;
            }
            Object[] objectArray = super.getChildren(element);
            return objectArray;
        }
        catch (ModelException modelException) {
            Object[] objectArray = NO_CHILDREN;
            return objectArray;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    private Object[] filterExternal(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<String, Object> pr = new HashMap<String, Object>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IModelElement) {
                String name = ((IModelElement)element).getElementName();
                if (pr.containsKey(name)) {
                    IModelElement pre = (IModelElement)pr.get(name);
                    IProjectFragment preModule = (IProjectFragment)pre.getAncestor(3);
                    IProjectFragment elementModule = (IProjectFragment)((IModelElement)element).getAncestor(3);
                    if (preModule.isExternal() && !elementModule.isExternal()) {
                        result.remove(pre);
                        result.add(element);
                        pr.put(name, element);
                    }
                } else {
                    result.add(element);
                    pr.put(name, element);
                }
            } else {
                result.add(element);
            }
            ++i;
        }
        return result.toArray();
    }

    private Object[] getScriptFolderContents(IScriptFolder fragment) throws ModelException {
        ISourceModule[] sourceRefs = fragment.getSourceModules();
        Object[] result = new Object[]{};
        int i = 0;
        while (i < sourceRefs.length) {
            result = ScriptBrowsingContentProvider.concatenate(result, this.removeImportAndPackageDeclarations(this.getChildren(sourceRefs[i])));
            ++i;
        }
        return ScriptBrowsingContentProvider.concatenate(result, fragment.getForeignResources());
    }

    private Object[] removeImportAndPackageDeclarations(Object[] members) {
        ArrayList<Object> tempResult = new ArrayList<Object>(members.length);
        int i = 0;
        while (i < members.length) {
            if (!(members[i] instanceof IPackageDeclaration)) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        return tempResult.toArray();
    }

    private Object[] getChildren(IType type) throws ModelException {
        IModelElement[] members = type.getChildren();
        ArrayList<IModelElement> tempResult = new ArrayList<IModelElement>(members.length);
        tempResult.addAll(Arrays.asList(type.getChildren()));
        return tempResult.toArray();
    }

    @Override
    protected Object[] getProjectFragments(IScriptProject project) throws ModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IProjectFragment[] roots = project.getProjectFragments();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            if (!root.isExternal()) {
                IModelElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                list.add(root);
            }
            ++i;
        }
        return ScriptBrowsingContentProvider.concatenate(list.toArray(), project.getForeignResources());
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof Collection) {
            Collection col = (Collection)newInput;
            newInput = !col.isEmpty() ? col.iterator().next() : null;
        }
        this.fInput = newInput;
    }

    @Override
    public void dispose() {
        super.dispose();
        DLTKCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e.getStatus());
        }
    }

    protected void processDelta(IModelElementDelta delta) throws ModelException {
        IModelElementDelta[] affectedChildren;
        IModelElement inputsParent;
        IProjectFragment pkgRoot;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IModelElement element = delta.getElement();
        boolean isElementValidForView = this.fBrowsingPart.isValidElement(element);
        if (element != null && element.getElementType() == 5 && !this.isOnBuildPath((ISourceModule)element)) {
            return;
        }
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(null);
            return;
        }
        if (kind == 2) {
            Object parent = this.internalGetParent(element);
            if (isElementValidForView) {
                if (element instanceof ISourceModule && !((ISourceModule)element).isWorkingCopy()) {
                    this.postRefresh(null);
                } else if (element instanceof ISourceModule && ((ISourceModule)element).isWorkingCopy()) {
                    this.postRefresh(null);
                } else if (parent instanceof ISourceModule && !((ISourceModule)parent).isWorkingCopy()) {
                    if (element instanceof ISourceModule && ((ISourceModule)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (element instanceof ISourceModule && ((ISourceModule)element).isWorkingCopy() && parent != null && parent.equals(this.fInput)) {
                    this.postRefresh(null);
                } else {
                    this.postRemove(element);
                }
            }
            if (this.fBrowsingPart.isAncestorOf(element, this.fInput)) {
                if (element instanceof ISourceModule && ((ISourceModule)element).isWorkingCopy()) {
                    this.postAdjustInputAndSetSelection(((IModelElement)this.fInput).getPrimaryElement());
                } else {
                    this.postAdjustInputAndSetSelection(null);
                }
            }
            if (this.fInput != null && this.fInput.equals(element)) {
                this.postRefresh(null);
            }
            if (parent instanceof IScriptFolder && this.fBrowsingPart.isValidElement(parent) && this.isScriptFolderEmpty((IModelElement)((IScriptFolder)parent)) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(null);
            }
            return;
        }
        if (kind == 1 && delta.getMovedFromElement() != null && element instanceof ISourceModule) {
            return;
        }
        if (kind == 1) {
            if (isElementValidForView) {
                Object parent = this.internalGetParent(element);
                if (element instanceof ISourceModule && !((ISourceModule)element).isWorkingCopy()) {
                    this.postAdd(parent, ((ISourceModule)element).getTypes());
                } else if (!(parent instanceof ISourceModule) || ((ISourceModule)parent).isWorkingCopy()) {
                    if (element instanceof ISourceModule && ((ISourceModule)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    } else {
                        this.postAdd(parent, element);
                    }
                }
            } else if (this.fInput == null) {
                IModelElement newInput = this.fBrowsingPart.findInputForJavaElement(element);
                if (newInput != null) {
                    this.postAdjustInputAndSetSelection(element);
                }
            } else if (element instanceof IType && this.fBrowsingPart.isValidInput(element)) {
                IModelElement cu1 = element.getAncestor(5);
                IModelElement cu2 = ((IModelElement)this.fInput).getAncestor(5);
                if (cu1 != null && cu2 != null && cu1.equals(cu2)) {
                    this.postAdjustInputAndSetSelection(element);
                }
            }
            return;
        }
        if (kind == 4) {
            if (this.fInput != null && this.fInput.equals(element) && (flags & 8) != 0 && (flags & 0x4000) != 0) {
                this.postRefresh(null, true);
                return;
            }
            if (isElementValidForView && (flags & 2) != 0) {
                this.postUpdateIcon(element);
            }
        }
        if (this.isBuildPathChange(delta)) {
            this.postRefresh(null);
        }
        if ((flags & 0x8000) != 0 && this.fInput instanceof IModelElement && (pkgRoot = (IProjectFragment)element).equals(inputsParent = ((IModelElement)this.fInput).getAncestor(3))) {
            this.postRefresh(null);
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            if (element instanceof IScriptFolder) {
                IModelElement parent = (IModelElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element);
                } else {
                    this.postRefresh(parent);
                }
            }
            if (element instanceof IProjectFragment && isElementValidForView) {
                this.postRefresh(this.skipProjectProjectFragment((IProjectFragment)element));
                return;
            }
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnBuildPath(ISourceModule element) throws ModelException {
        IScriptProject project = element.getScriptProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnBuildpath((IModelElement)element);
    }

    private void postUpdateIcon(final IModelElement element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = ScriptBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ScriptBrowsingContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void postRefresh(final Object root, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = ScriptBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ScriptBrowsingContentProvider.this.fViewer.refresh(root, updateLabels);
                }
            }
        });
    }

    private void postRefresh(Object root) {
        this.postRefresh(root, false);
    }

    private void postAdd(Object parent, Object element) {
        this.postAdd(parent, new Object[]{element});
    }

    private void postAdd(final Object parent, final Object[] elements) {
        if (elements == null || elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = ScriptBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Object[] newElements = ScriptBrowsingContentProvider.this.getNewElements(elements);
                    if (ScriptBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        if (ScriptBrowsingContentProvider.this.fViewer.testFindItem(parent) == null) {
                            Object root = ((AbstractTreeViewer)ScriptBrowsingContentProvider.this.fViewer).getInput();
                            if (root != null) {
                                ((AbstractTreeViewer)ScriptBrowsingContentProvider.this.fViewer).add(root, newElements);
                            }
                        } else {
                            ((AbstractTreeViewer)ScriptBrowsingContentProvider.this.fViewer).add(parent, newElements);
                        }
                    } else if (ScriptBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)ScriptBrowsingContentProvider.this.fViewer).add(newElements);
                    } else if (ScriptBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)ScriptBrowsingContentProvider.this.fViewer).add(newElements);
                    }
                    if (ScriptBrowsingContentProvider.this.fViewer.testFindItem(elements[0]) != null) {
                        ScriptBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(elements[0]);
                    }
                }
            }
        });
    }

    private Object[] getNewElements(Object[] elements) {
        int elementsLength = elements.length;
        ArrayList<Object> result = new ArrayList<Object>(elementsLength);
        int i = 0;
        while (i < elementsLength) {
            Object element = elements[i];
            if (this.fViewer.testFindItem(element) == null) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray();
    }

    private void postRemove(Object element) {
        this.postRemove(new Object[]{element});
    }

    private void postRemove(final Object[] elements) {
        if (elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = ScriptBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (ScriptBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)ScriptBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (ScriptBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)ScriptBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (ScriptBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)ScriptBrowsingContentProvider.this.fViewer).remove(elements);
                    }
                }
            }
        });
    }

    private void postAdjustInputAndSetSelection(final Object element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = ScriptBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.setRedraw(false);
                    ScriptBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(element);
                    ctrl.setRedraw(true);
                }
            }
        });
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    private boolean isDisplayThread() {
        Control ctrl = this.fViewer.getControl();
        if (ctrl == null) {
            return false;
        }
        Display currentDisplay = Display.getCurrent();
        return currentDisplay != null && currentDisplay.equals(ctrl.getDisplay());
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.fBrowsingPart.setProcessSelectionEvents(false);
            try {
                if (this.isDisplayThread() && this.fReadsInDisplayThread == 0) {
                    ctrl.getDisplay().syncExec(r);
                } else {
                    ctrl.getDisplay().asyncExec(r);
                }
            }
            finally {
                this.fBrowsingPart.setProcessSelectionEvents(true);
            }
        }
    }

    @Override
    protected Object internalGetParent(Object element) {
        if (element instanceof IScriptProject) {
            return ((IScriptProject)element).getModel();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IModelElement jParent = DLTKCore.create((IResource)parent);
            if (jParent != null) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IScriptFolder) {
            IProjectFragment parent = (IProjectFragment)((IScriptFolder)element).getParent();
            return this.skipProjectProjectFragment(parent);
        }
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getParent();
        }
        return null;
    }
}

