/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class BuiltinMethods {
    private static final RubyClassType fixnumType = new RubyClassType("Fixnum");
    private static final RubyClassType arrayType = new RubyClassType("Array");
    private static final RubyClassType strType = new RubyClassType("String");
    private static final RubyClassType classType = new RubyClassType("Class");
    private static final IEvaluatedType boolType = new AmbiguousType(new IEvaluatedType[]{new RubyClassType("TrueClass"), new RubyClassType("FalseClass")});
    private static Map builtinClasses = new HashMap();

    static {
        BuiltinClass klass = BuiltinMethods.addClass(new BuiltinClass("Object"));
        klass.addMethod("object_id", new SimpleIntrinsicMethod((IEvaluatedType)fixnumType));
        klass.addMethod("__id__", new SimpleIntrinsicMethod((IEvaluatedType)fixnumType));
        klass.addMethod("send", new SimpleIntrinsicMethod(UnknownType.INSTANCE));
        klass.addMethod("class", new ClassMethod());
        klass.addMethod("clone", new ReceiverTypeReturningMethod());
        klass.addMethod("dup", new ReceiverTypeReturningMethod());
        klass.addMethod("extend", new SimpleIntrinsicMethod(UnknownType.INSTANCE));
        klass.addMethod("freeze", new ReceiverTypeReturningMethod());
        klass.addMethod("frozen?", new SimpleIntrinsicMethod(boolType));
        klass.addMethod("hash", new SimpleIntrinsicMethod((IEvaluatedType)fixnumType));
        klass.addMethod("inspect", new SimpleIntrinsicMethod((IEvaluatedType)strType));
        klass.addMethod("instance_eval", new SimpleIntrinsicMethod(UnknownType.INSTANCE));
        klass.addMethod("instance_of?", new SimpleIntrinsicMethod(boolType));
        klass.addMethod("instance_variable_get", new SimpleIntrinsicMethod(UnknownType.INSTANCE));
        klass.addMethod("instance_variable_set", new SimpleIntrinsicMethod(UnknownType.INSTANCE));
        klass.addMethod("instance_variables", new SimpleIntrinsicMethod((IEvaluatedType)arrayType));
        klass.addMethod("is_a?", new SimpleIntrinsicMethod(boolType));
        klass.addMethod("kind_of?", new SimpleIntrinsicMethod(boolType));
        klass.addMethod("nil?", new SimpleIntrinsicMethod(boolType));
        klass.addMethod("respond_to?", new SimpleIntrinsicMethod(boolType));
        klass.addMethod("to_a", new SimpleIntrinsicMethod((IEvaluatedType)arrayType));
        klass.addMethod("to_s", new SimpleIntrinsicMethod((IEvaluatedType)strType));
        klass.addMethod("to_i", new SimpleIntrinsicMethod((IEvaluatedType)fixnumType));
        klass = BuiltinMethods.addClass(new BuiltinClass("Class"));
        klass.addMethod("new", new NewMethod());
        klass = BuiltinMethods.addClass(new BuiltinClass("Fixnum"));
        klass.addMethod("abs", new SimpleIntrinsicMethod((IEvaluatedType)fixnumType));
    }

    private static BuiltinClass addClass(BuiltinClass klass) {
        builtinClasses.put(klass.getName(), klass);
        return klass;
    }

    public static IEvaluatedType getIntrinsicMethodReturnType(IEvaluatedType receiver, String methodName, IEvaluatedType[] arguments) {
        if (receiver instanceof IClassType) {
            return BuiltinMethods.getIntrinsicMethodReturnType((IClassType)receiver, methodName, arguments);
        }
        if (receiver instanceof AmbiguousType) {
            HashSet<IEvaluatedType> possibleReturns = new HashSet<IEvaluatedType>();
            AmbiguousType ambiguousType = (AmbiguousType)receiver;
            IEvaluatedType[] possibleTypes = ambiguousType.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                IEvaluatedType type = possibleTypes[i];
                IEvaluatedType possibleReturn = BuiltinMethods.getIntrinsicMethodReturnType(type, methodName, arguments);
                possibleReturns.add(possibleReturn);
                ++i;
            }
            return RubyTypeInferencingUtils.combineTypes(possibleReturns);
        }
        return null;
    }

    public static IEvaluatedType getIntrinsicMethodReturnType(IClassType receiver, String methodName, IEvaluatedType[] arguments) {
        IntrinsicMethod method;
        String className = BuiltinMethods.getPossibleIntrinsicClassName(receiver);
        BuiltinClass klass = (BuiltinClass)builtinClasses.get(className);
        if (klass != null && (method = klass.getMethod(methodName)) != null) {
            return method.getReturnType((IEvaluatedType)receiver, arguments);
        }
        return null;
    }

    public static Collection getIntrinsicMethods(IEvaluatedType receiver) {
        if (receiver instanceof IClassType) {
            String className = BuiltinMethods.getPossibleIntrinsicClassName((IClassType)receiver);
            BuiltinClass klass = (BuiltinClass)builtinClasses.get(className);
            if (klass != null) {
                return klass.getMethods();
            }
            return null;
        }
        if (receiver instanceof AmbiguousType) {
            HashSet methods = new HashSet();
            AmbiguousType ambiguousType = (AmbiguousType)receiver;
            IEvaluatedType[] possibleTypes = ambiguousType.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                IEvaluatedType type = possibleTypes[i];
                Collection typeMethods = BuiltinMethods.getIntrinsicMethods(type);
                methods.addAll(typeMethods);
                ++i;
            }
            return methods;
        }
        return null;
    }

    private static String getPossibleIntrinsicClassName(IClassType receiver) {
        if (receiver instanceof RubyClassType) {
            return "Class";
        }
        return null;
    }

    public static class BuiltinClass {
        private final String name;
        private Map methods = new HashMap();

        public BuiltinClass(String name) {
            this.name = name;
        }

        public void addMethod(String name, IntrinsicMethod method) {
            this.methods.put(name, method);
        }

        public String getName() {
            return this.name;
        }

        IntrinsicMethod getMethod(String name) {
            return (IntrinsicMethod)this.methods.get(name);
        }

        public Collection getMethods() {
            return this.methods.values();
        }
    }

    private static final class ClassMethod
    implements IntrinsicMethod {
        private ClassMethod() {
        }

        public boolean dependsOnArguments() {
            return false;
        }

        public boolean dependsOnReceiver() {
            return true;
        }

        public IEvaluatedType getReturnType() {
            return classType;
        }

        public IEvaluatedType getReturnType(IEvaluatedType receiver, IEvaluatedType[] arguments) {
            return RubyTypeInferencingUtils.getAmbiguousMetaType(receiver);
        }
    }

    public static interface IntrinsicMethod {
        public boolean dependsOnReceiver();

        public boolean dependsOnArguments();

        public IEvaluatedType getReturnType();

        public IEvaluatedType getReturnType(IEvaluatedType var1, IEvaluatedType[] var2);
    }

    private static final class NewMethod
    implements IntrinsicMethod {
        private NewMethod() {
        }

        public boolean dependsOnArguments() {
            return false;
        }

        public boolean dependsOnReceiver() {
            return true;
        }

        public IEvaluatedType getReturnType() {
            return null;
        }

        public IEvaluatedType getReturnType(IEvaluatedType receiver, IEvaluatedType[] arguments) {
            if (receiver instanceof RubyClassType) {
                RubyClassType rubyClassType = (RubyClassType)receiver;
                String key = rubyClassType.getModelKey();
                if (!key.endsWith("%")) {
                    return new RubyClassType(String.valueOf(key) + "%");
                }
                return null;
            }
            if (receiver instanceof AmbiguousType) {
                HashSet<IEvaluatedType> possibleReturns = new HashSet<IEvaluatedType>();
                AmbiguousType ambiguousType = (AmbiguousType)receiver;
                IEvaluatedType[] possibleTypes = ambiguousType.getPossibleTypes();
                int i = 0;
                while (i < possibleTypes.length) {
                    IEvaluatedType type = possibleTypes[i];
                    IEvaluatedType possibleReturn = this.getReturnType(type, arguments);
                    possibleReturns.add(possibleReturn);
                    ++i;
                }
                return RubyTypeInferencingUtils.combineTypes(possibleReturns);
            }
            return null;
        }
    }

    private static final class ReceiverTypeReturningMethod
    implements IntrinsicMethod {
        private ReceiverTypeReturningMethod() {
        }

        public boolean dependsOnArguments() {
            return false;
        }

        public boolean dependsOnReceiver() {
            return true;
        }

        public IEvaluatedType getReturnType() {
            return null;
        }

        public IEvaluatedType getReturnType(IEvaluatedType receiver, IEvaluatedType[] arguments) {
            return receiver;
        }
    }

    private static class SimpleIntrinsicMethod
    implements IntrinsicMethod {
        private final IEvaluatedType returnType;

        public SimpleIntrinsicMethod(IEvaluatedType returnType) {
            this.returnType = returnType;
        }

        public boolean dependsOnArguments() {
            return false;
        }

        public boolean dependsOnReceiver() {
            return false;
        }

        public IEvaluatedType getReturnType() {
            return this.returnType;
        }

        public IEvaluatedType getReturnType(IEvaluatedType receiver, IEvaluatedType[] arguments) {
            return this.getReturnType();
        }
    }
}

