/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.FileHandles;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.environment.IFileStoreProvider;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.dltk.core.internal.rse.perfomance.RSEPerfomanceStatistics;
import org.eclipse.dltk.core.internal.rse.ssh.RSESshManager;
import org.eclipse.dltk.ssh.core.ISshConnection;
import org.eclipse.dltk.ssh.core.ISshFileHandle;
import org.eclipse.rse.core.model.IHost;

public class RSEFileHandle
implements IFileHandle,
IFileStoreProvider {
    private static final int SYMLINK_CONNECTION_TIMEOUT = 30000;
    private static final int CACHE_LIMIT = 1000;
    private static final long CACHE_ENTRY_LIFETIME = 10000L;
    private static final Map<IFileStore, CacheEntry> cache = new HashMap<IFileStore, CacheEntry>();
    private final IFileStore file;
    private final IEnvironment environment;
    private ISshFileHandle sshFile;

    public RSEFileHandle(IEnvironment env, IFileStore file) {
        this.environment = env;
        this.file = file;
    }

    private void fetchSshFile() {
        RSEEnvironment rseEnv;
        IHost host;
        ISshConnection connection;
        if (this.sshFile != null) {
            return;
        }
        if (this.environment instanceof RSEEnvironment && (connection = RSESshManager.getConnection(host = (rseEnv = (RSEEnvironment)this.environment).getHost())) != null) {
            try {
                this.sshFile = connection.getHandle((IPath)new Path(this.getPathString()));
            }
            catch (Exception e) {
                DLTKRSEPlugin.log("Failed to locate direct ssh connection", e);
            }
        }
    }

    public RSEFileHandle(IEnvironment env, IFileStore file, ISshFileHandle sshFile) {
        this.environment = env;
        this.file = file;
        this.sshFile = sshFile;
    }

    public RSEFileHandle(IEnvironment env, URI locationURI) {
        this(env, RSEEnvironment.getStoreFor(locationURI));
    }

    public boolean exists() {
        if (!this.environment.connect()) {
            return false;
        }
        this.fetchSshFile();
        if (this.sshFile != null) {
            return this.sshFile.exists();
        }
        try {
            return this.fetchInfo(false).exists();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileInfo fetchInfo(boolean force) {
        Map<IFileStore, CacheEntry> map;
        boolean isRemote = !this.environment.isLocal();
        long now = 0L;
        if (isRemote && !force) {
            CacheEntry entry;
            map = cache;
            synchronized (map) {
                entry = cache.get(this.getCacheKey());
            }
            if (entry != null && (now = System.currentTimeMillis()) - entry.timestamp < 10000L) {
                return entry.fileInfo;
            }
        }
        IFileInfo info = this.file.fetchInfo();
        if (isRemote) {
            if (now == 0L) {
                now = System.currentTimeMillis();
            }
            map = cache;
            synchronized (map) {
                RSEFileHandle.checkCacheLimit();
                cache.put(this.getCacheKey(), new CacheEntry(info, now));
            }
        }
        return info;
    }

    private static void checkCacheLimit() {
        if (cache.size() > 1000) {
            cache.clear();
        }
    }

    private final IFileStore getCacheKey() {
        return this.file;
    }

    public String toOSString() {
        return this.environment.convertPathToString(this.getPath());
    }

    public String getCanonicalPath() {
        return this.environment.getCanonicalPath(this.getPath());
    }

    public IFileHandle getChild(String childname) {
        if (!this.environment.connect()) {
            try {
                URI childURI = new URI(String.valueOf(this.toURI().toString()) + "/" + childname);
                return new RSEFileHandle(this.environment, childURI);
            }
            catch (URISyntaxException e) {
                DLTKRSEPlugin.log(e);
            }
        }
        this.fetchSshFile();
        IFileStore childStore = this.file.getChild(childname);
        if (this.sshFile != null) {
            return new RSEFileHandle(this.environment, childStore, this.sshFile.getChild(childname));
        }
        return new RSEFileHandle(this.environment, childStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileHandle[] getChildren() {
        if (!this.environment.connect()) {
            return null;
        }
        this.fetchSshFile();
        if (this.sshFile != null) {
            try {
                ISshFileHandle[] children = this.sshFile.getChildren((IProgressMonitor)new NullProgressMonitor());
                IFileHandle[] rseChildren = new IFileHandle[children.length];
                int i = 0;
                while (i < children.length) {
                    ISshFileHandle child = children[i];
                    IFileStore childStore = this.file.getChild(child.getName());
                    rseChildren[i] = new RSEFileHandle(this.environment, childStore, child);
                    ++i;
                }
                return rseChildren;
            }
            catch (CoreException e) {
                DLTKRSEPlugin.log(e);
            }
        }
        try {
            IFileInfo[] infos = this.file.childInfos(0, (IProgressMonitor)new NullProgressMonitor());
            if (infos.length != 0) {
                Map<IFileStore, CacheEntry> rseChildren = cache;
                synchronized (rseChildren) {
                    RSEFileHandle.checkCacheLimit();
                }
            }
            IFileHandle[] children = new IFileHandle[infos.length];
            long now = System.currentTimeMillis();
            int i = 0;
            while (i < infos.length) {
                IFileInfo childInfo = infos[i];
                children[i] = new RSEFileHandle(this.environment, this.file.getChild(childInfo.getName()));
                IFileStore childCacheKey = ((RSEFileHandle)children[i]).getCacheKey();
                Map<IFileStore, CacheEntry> map = cache;
                synchronized (map) {
                    cache.put(childCacheKey, new CacheEntry(childInfo, now));
                }
                ++i;
            }
            return children;
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public URI toURI() {
        return this.file.toURI();
    }

    public String getName() {
        return this.file.getName();
    }

    public IFileHandle getParent() {
        IFileStore parent = this.file.getParent();
        if (parent == null) {
            return null;
        }
        return new RSEFileHandle(this.environment, parent);
    }

    public IPath getPath() {
        return new Path(this.getPathString());
    }

    private String getPathString() {
        return this.file.toURI().getPath();
    }

    public boolean isDirectory() {
        if (!this.environment.connect()) {
            return false;
        }
        this.fetchSshFile();
        if (this.sshFile != null) {
            return this.sshFile.isDirectory();
        }
        return this.fetchInfo(false).isDirectory();
    }

    public boolean isFile() {
        if (!this.environment.connect()) {
            return false;
        }
        this.fetchSshFile();
        if (this.sshFile != null) {
            return this.sshFile.exists() && !this.sshFile.isDirectory();
        }
        IFileInfo info = this.fetchInfo(false);
        return info.exists() && !info.isDirectory();
    }

    public boolean isSymlink() {
        if (!this.environment.connect()) {
            return false;
        }
        this.fetchSshFileWait();
        if (this.sshFile != null) {
            return this.sshFile.isSymlink();
        }
        return this.fetchInfo(false).getAttribute(32);
    }

    private void fetchSshFileWait() {
        long startTime = System.currentTimeMillis();
        while (this.sshFile == null && System.currentTimeMillis() - startTime < 30000L) {
            this.fetchSshFile();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
    }

    private InputStream internalOpenInputStream(IProgressMonitor monitor) throws IOException {
        if (!this.environment.connect()) {
            return null;
        }
        this.fetchSshFile();
        if (this.sshFile != null) {
            try {
                return this.sshFile.getInputStream(monitor);
            }
            catch (CoreException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        try {
            return this.file.openInputStream(0, monitor);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        if (!this.environment.connect()) {
            return null;
        }
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            return new CountStream(this.internalOpenInputStream(monitor));
        }
        return this.internalOpenInputStream(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openOutputStream(IProgressMonitor monitor) throws IOException {
        if (!this.environment.connect()) {
            return null;
        }
        Map<IFileStore, CacheEntry> map = cache;
        synchronized (map) {
            cache.clear();
        }
        this.fetchSshFile();
        if (this.sshFile != null) {
            try {
                return this.sshFile.getOutputStream(monitor);
            }
            catch (CoreException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        try {
            return new BufferedOutputStream(this.file.openOutputStream(0, monitor)){

                public void close() throws IOException {
                    super.close();
                    RSEFileHandle.this.clearLastModifiedCache();
                }
            };
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RSEFileHandle) {
            RSEFileHandle anotherFile = (RSEFileHandle)obj;
            return this.file.equals(anotherFile.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.toOSString();
    }

    public long lastModified() {
        if (!this.environment.connect()) {
            return 0L;
        }
        this.fetchSshFile();
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        long lm = 0L;
        lm = this.sshFile != null ? this.sshFile.lastModificationTime() : this.fetchInfo(false).getLastModified();
        p.done("#", "Return file timestamp", 0L);
        return lm;
    }

    public long length() {
        if (!this.environment.connect()) {
            return 0L;
        }
        this.fetchSshFile();
        if (this.sshFile != null) {
            return this.sshFile.getSize();
        }
        return this.fetchInfo(false).getLength();
    }

    public IPath getFullPath() {
        return EnvironmentPathUtils.getFullPath((IEnvironment)this.environment, (IPath)this.getPath());
    }

    public String getEnvironmentId() {
        return this.environment.getId();
    }

    public IFileStore getFileStore() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLastModifiedCache() {
        Map<IFileStore, CacheEntry> map = cache;
        synchronized (map) {
            cache.remove(this.getCacheKey());
        }
    }

    public String resolvePath() {
        String currentPath = this.getPathString();
        if (this.environment.connect() && this.isSymlink()) {
            if (this.sshFile != null) {
                String link = this.sshFile.readLink();
                if (link != null) {
                    if (link.startsWith("/")) {
                        if (!link.equals(currentPath)) {
                            return this.environment.getFile((IPath)new Path(link)).getCanonicalPath();
                        }
                    } else {
                        IPath fullLink = this.getPath().removeLastSegments(1).append(link);
                        if (!currentPath.equals(fullLink.toString())) {
                            return this.environment.getFile(fullLink).getCanonicalPath();
                        }
                    }
                }
            } else {
                String linkTarget;
                IFileInfo info = this.file.fetchInfo();
                if (info != null && info.getAttribute(32) && (linkTarget = info.getStringAttribute(64)) != null && !currentPath.equals(linkTarget)) {
                    Path link = new Path(linkTarget);
                    IFileStore resolved = link.isAbsolute() ? this.file.getFileSystem().getStore((IPath)link) : this.file.getFileStore((IPath)link);
                    return resolved.toURI().getPath();
                }
            }
        }
        return currentPath;
    }

    public void move(IFileHandle destination) throws CoreException {
        this.fetchSshFile();
        if (this.sshFile != null) {
            this.sshFile.move(FileHandles.asPath((IFileHandle)destination, (IEnvironment)this.environment));
        } else {
            this.file.move(FileHandles.asFileStore((IFileHandle)destination), 2, null);
        }
    }

    private static class CacheEntry {
        final IFileInfo fileInfo;
        final long timestamp;

        public CacheEntry(IFileInfo fileInfo, long timestamp) {
            this.fileInfo = fileInfo;
            this.timestamp = timestamp;
        }
    }

    private static final class CountStream
    extends BufferedInputStream {
        private InputStream stream;

        public CountStream(InputStream stream) {
            super(stream);
        }

        public int read() throws IOException {
            int read = this.stream.read();
            if (read != -1) {
                RSEPerfomanceStatistics.inc(0);
            }
            return read;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.stream.read(b, off, len);
            if (read != -1) {
                RSEPerfomanceStatistics.inc(0, read);
            }
            return read;
        }

        public int read(byte[] b) throws IOException {
            int read = this.stream.read(b);
            if (read != -1) {
                RSEPerfomanceStatistics.inc(0, read);
            }
            return read;
        }
    }
}

