/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.File;
import java.io.Reader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.ui.manpages.Documentation;
import org.eclipse.dltk.tcl.ui.manpages.InterpreterDocumentation;
import org.eclipse.dltk.tcl.ui.manpages.ManPageFolder;
import org.eclipse.dltk.tcl.ui.manpages.ManPageLoader;
import org.eclipse.dltk.tcl.ui.manpages.ManPageResource;
import org.eclipse.dltk.tcl.ui.manpages.ManpagesPackage;
import org.eclipse.dltk.ui.documentation.DocumentationFileResponse;
import org.eclipse.dltk.ui.documentation.DocumentationUtils;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TclManPagesDocumentationProvider
implements IScriptDocumentationProvider,
IScriptDocumentationProviderExtension {
    private ManPageResource manPages = null;
    private IPropertyChangeListener changeListener = null;

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        IProjectFragment fragment = (IProjectFragment)element.getAncestor(3);
        if (fragment != null && fragment.isBuiltin()) {
            return DocumentationUtils.getReader((IDocumentationResponse)this.describeKeyword(element.getElementName(), (IModelElement)element));
        }
        return null;
    }

    public Reader getInfo(String content) {
        return DocumentationUtils.getReader((IDocumentationResponse)this.describeKeyword(content, null));
    }

    protected void initalizeLocations(boolean force) {
        if (!force && this.manPages != null) {
            return;
        }
        IPreferenceStore prefStore = TclUI.getDefault().getPreferenceStore();
        this.manPages = ManPageLoader.load();
        if (this.manPages != null && this.changeListener == null) {
            this.changeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    TclManPagesDocumentationProvider.this.initalizeLocations(true);
                }
            };
            prefStore.addPropertyChangeListener(this.changeListener);
        }
    }

    private Documentation selectSource(IModelElement context) {
        IScriptProject project;
        this.initalizeLocations(false);
        if (this.manPages == null) {
            return null;
        }
        if (context != null && (project = context.getScriptProject()) != null) {
            Documentation doc;
            InterpreterDocumentation iDoc;
            IInterpreterInstall install;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
            }
            catch (CoreException e) {
                TclUI.error(e);
                install = null;
            }
            if (install != null && (iDoc = (InterpreterDocumentation)install.findExtension(ManpagesPackage.Literals.INTERPRETER_DOCUMENTATION)) != null && (doc = this.manPages.findById(iDoc.getDocumentationId())) != null) {
                return doc;
            }
        }
        return this.manPages.findDefault();
    }

    public IDocumentationResponse describeKeyword(String keyword, IModelElement context) {
        Documentation documentation = this.selectSource(context);
        if (documentation != null) {
            for (ManPageFolder f : documentation.getFolders()) {
                File file;
                int spacePos;
                String filename = (String)f.getKeywords().get((Object)keyword);
                if (filename == null && (spacePos = keyword.indexOf(32)) != -1) {
                    filename = (String)f.getKeywords().get((Object)keyword.substring(0, spacePos));
                }
                if (filename == null || !(file = new File(f.getPath(), filename)).isFile()) continue;
                return new DocumentationFileResponse((Object)keyword, file);
            }
        }
        return null;
    }
}

