/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildContextExtension;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBuildContext
implements IBuildContext,
IBuildContextExtension {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final int buildType;
    protected final ISourceModule module;
    private char[] contents;
    private ISourceLineTracker lineTracker = null;
    private String sourceContents;

    @Override
    public Object get(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void set(String attribute, Object value) {
        if (value == null) {
            this.attributes.remove(attribute);
        } else {
            this.attributes.put(attribute, value);
        }
    }

    protected AbstractBuildContext(ISourceModule module, int buildType) {
        this.module = module;
        this.buildType = buildType;
    }

    @Override
    public int getBuildType() {
        return this.buildType;
    }

    @Override
    public final char[] getContents() {
        if (this.contents == null) {
            try {
                this.contents = this.module.getSourceAsCharArray();
            }
            catch (ModelException e) {
                DLTKCore.error(NLS.bind((String)Messages.AbstractBuildContext_errorRetrievingContentsOf, (Object)this.module.getElementName()), (Throwable)((Object)e));
                this.contents = CharOperation.NO_CHAR;
            }
        }
        return this.contents;
    }

    @Override
    public ISourceLineTracker getLineTracker() {
        if (this.lineTracker == null) {
            this.lineTracker = TextUtils.createLineTracker(this.getContents());
        }
        return this.lineTracker;
    }

    @Override
    public void setLineTracker(ISourceLineTracker tracker) {
        this.lineTracker = tracker;
    }

    @Override
    public boolean isLineTrackerCreated() {
        return this.lineTracker != null;
    }

    @Override
    public final ISourceModule getSourceModule() {
        return this.module;
    }

    @Override
    public final IFile getFile() {
        return (IFile)this.module.getResource();
    }

    @Override
    public String getSourceContents() {
        if (this.sourceContents == null) {
            this.sourceContents = new String(this.getContents());
        }
        return this.sourceContents;
    }

    @Override
    public char[] getContentsAsCharArray() {
        return this.getContents();
    }

    @Override
    public IModelElement getModelElement() {
        return this.getSourceModule();
    }

    @Override
    public String getFileName() {
        return this.getSourceModule().getElementName();
    }
}

