/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.internal.core.RRecordMember;
import org.eclipse.dltk.javascript.internal.core.TypeSystems;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRTypeFactory;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RArrayType;
import org.eclipse.dltk.javascript.typeinfo.RClassType;
import org.eclipse.dltk.javascript.typeinfo.RFunctionType;
import org.eclipse.dltk.javascript.typeinfo.RLocalType;
import org.eclipse.dltk.javascript.typeinfo.RMapType;
import org.eclipse.dltk.javascript.typeinfo.RRecordType;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.RUnionType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.emf.common.util.EList;

public class RTypes {
    private static final IRType UNDEFINED_TYPE = new Undefined();
    private static final IRType ANY_TYPE = RTypes.initRType(new Any());
    private static final IRType NONE_TYPE = new None();
    static final IRType EMPTY_ARRAY_ITEM_TYPE = new EmptyArrayItem();
    private static final IRArrayType ARRAY_OF = RTypes.arrayOf(TypeSystems.GLOBAL, EMPTY_ARRAY_ITEM_TYPE);
    private static final IRRecordType EMPTY_RECORD_TYPE = new EmptyRecordType();
    public static final IRSimpleType FUNCTION = RTypes.simple(TypeSystems.GLOBAL, Types.FUNCTION);
    public static final IRSimpleType STRING = RTypes.simple(TypeSystems.GLOBAL, Types.STRING);
    public static final IRSimpleType NUMBER = RTypes.simple(TypeSystems.GLOBAL, Types.NUMBER);
    public static final IRSimpleType BOOLEAN = RTypes.simple(TypeSystems.GLOBAL, Types.BOOLEAN);
    public static final IRSimpleType OBJECT = RTypes.simple(TypeSystems.GLOBAL, Types.OBJECT);
    public static final IRSimpleType REGEXP = RTypes.simple(TypeSystems.GLOBAL, Types.REGEXP);
    public static final IRSimpleType ERROR = RTypes.simple(TypeSystems.GLOBAL, Types.ERROR);

    private RTypes() {
    }

    private static IRType initRType(IRType defaultValue) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] elements;
            String name = defaultValue.getClass().getSimpleName();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.dltk.javascript.core.typeinfo");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("runtimeType".equals(element.getName()) && name.equals(element.getAttribute("name"))) {
                    try {
                        return (IRType)element.createExecutableExtension("class");
                    }
                    catch (Exception e) {
                        JavaScriptPlugin.error(e);
                    }
                }
                ++n2;
            }
        }
        return defaultValue;
    }

    public static IRType undefined() {
        return UNDEFINED_TYPE;
    }

    public static IRType any() {
        return ANY_TYPE;
    }

    public static IRType none() {
        return NONE_TYPE;
    }

    public static IRArrayType arrayOf() {
        return ARRAY_OF;
    }

    public static IRSimpleType simple(ITypeSystem typeSystem, Type type) {
        if (Types.ARRAY == type) {
            return RTypes.arrayOf(typeSystem, RTypes.none());
        }
        return (IRSimpleType)type.toRType(typeSystem);
    }

    public static IRType simple(IRTypeDeclaration declaration) {
        return declaration.getSource().getMetaType().toRType(declaration);
    }

    public static IRClassType classType(ITypeSystem typeSystem, Type type) {
        return new RClassType(typeSystem, type);
    }

    public static IRClassType classType(IRTypeDeclaration declaration) {
        return new RClassType(declaration);
    }

    public static IRClassType classOf(IRType type) {
        if (type instanceof IRSimpleType) {
            return RTypes.classType(((IRSimpleType)type).getDeclaration());
        }
        return RTypes.classType(null);
    }

    public static IRMapType mapOf(IRType keyType, IRType valueType) {
        return new RMapType(keyType, valueType);
    }

    public static IRRecordType emptyRecordType() {
        return EMPTY_RECORD_TYPE;
    }

    public static IRRecordType recordType(ITypeSystem typeSystem, Collection<Member> members) {
        return new RRecordType(typeSystem, members);
    }

    public static IRRecordType recordType(Collection<IRRecordMember> members) {
        return new RRecordType(members);
    }

    public static IRRecordType recordType() {
        return new RRecordType();
    }

    public static IRRecordType recordType(@Nullable IValueReference argument) {
        if (argument != null) {
            ArrayList<IRRecordMember> members;
            Set<String> directChildren = argument.getDirectChildren();
            IRType type = JavaScriptValidations.typeOf(argument);
            if (type instanceof IRUnionType) {
                for (IRType unionTarget : ((IRUnionType)type).getTargets()) {
                    if (!(unionTarget instanceof IRRecordType)) continue;
                    type = unionTarget;
                    break;
                }
            }
            if (type instanceof IRRecordType) {
                if (directChildren.isEmpty()) {
                    return (IRRecordType)type;
                }
                members = new ArrayList(directChildren.size() + ((IRRecordType)type).getMembers().size());
                for (String childName : directChildren) {
                    IValueReference child = argument.getChild(childName);
                    if (!child.exists()) continue;
                    IRType memberType = JavaScriptValidations.typeOf(child);
                    members.add(new RRecordMember(childName, memberType != null ? memberType : RTypes.any(), child));
                }
                for (IRRecordMember member : ((IRRecordType)type).getMembers()) {
                    if (directChildren.contains(member.getName())) continue;
                    members.add(member);
                }
                return RTypes.recordType(members);
            }
            if (!directChildren.isEmpty()) {
                members = new ArrayList<IRRecordMember>(directChildren.size());
                for (String childName : directChildren) {
                    IValueReference child = argument.getChild(childName);
                    if (!child.exists()) continue;
                    IRType memberType = JavaScriptValidations.typeOf(child);
                    members.add(new RRecordMember(childName, memberType != null ? memberType : RTypes.any(), child));
                }
                return RTypes.recordType(members);
            }
            return RTypes.emptyRecordType();
        }
        return RTypes.emptyRecordType();
    }

    public static Set<String> memberNames(IRRecordType recordType) {
        Collection<IRRecordMember> members = recordType.getMembers();
        if (members.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(members.size());
        for (IRRecordMember member : members) {
            names.add(member.getName());
        }
        return names;
    }

    public static IRFunctionType functionType(ITypeSystem typeSystem, List<IRParameter> parameters, IRType returnType) {
        return new RFunctionType(typeSystem, parameters, returnType);
    }

    public static IRType union(Collection<IRType> targets) {
        return new RUnionType(targets);
    }

    public static IRArrayType arrayOf(ITypeSystem typeSystem, IRType itemType) {
        return new RArrayType(typeSystem, itemType);
    }

    public static IRLocalType localType(String name, IValueReference value) {
        return new RLocalType(name, value);
    }

    public static IRType create(ITypeSystem typeSystem, JSType type) {
        if (type == null) {
            return null;
        }
        IRType result = type.toRType(typeSystem);
        if (result != null) {
            return result;
        }
        IRTypeFactory[] iRTypeFactoryArray = TypeInfoManager.getRTypeFactories();
        int n = iRTypeFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRTypeFactory factory = iRTypeFactoryArray[n2];
            IRType runtimeType = factory.create(typeSystem, type);
            if (runtimeType != null) {
                return runtimeType;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    public static List<IRType> convert(ITypeSystem typeSystem, List<JSType> args) {
        int size = args.size();
        ArrayList<IRType> parameters = new ArrayList<IRType>(size);
        int i = 0;
        while (i < size) {
            parameters.add(RTypes.create(typeSystem, args.get(i)));
            ++i;
        }
        return parameters;
    }

    public static boolean isUndefined(IRType type) {
        if (type == RTypes.undefined()) {
            return true;
        }
        if (type instanceof IRUnionType) {
            return ((IRUnionType)type).getTargets().contains(RTypes.undefined());
        }
        return false;
    }

    static class Any
    extends RType {
        Any() {
        }

        @Override
        public String getName() {
            return "Any";
        }

        @Override
        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.TRUE;
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }

    static class EmptyArrayItem
    extends RType {
        EmptyArrayItem() {
        }

        @Override
        public String getName() {
            return "empty";
        }

        @Override
        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.TRUE;
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }

    static class EmptyRecordType
    extends RType
    implements IRRecordType {
        EmptyRecordType() {
        }

        @Override
        public String getName() {
            return "{}";
        }

        @Override
        public IRRecordMember getMember(String name) {
            return null;
        }

        @Override
        public Collection<IRRecordMember> getMembers() {
            return Collections.emptyList();
        }

        @Override
        public void init(ITypeSystem context, EList<Member> members) {
        }
    }

    static class None
    extends RType {
        None() {
        }

        @Override
        public String getName() {
            return "None";
        }

        @Override
        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.TRUE;
        }

        @Override
        public boolean isExtensible() {
            return true;
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }
    }

    static class Undefined
    extends RType {
        Undefined() {
        }

        @Override
        public String getName() {
            return "undefined";
        }

        @Override
        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.valueOf(type == this);
        }
    }
}

