/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ruby.core.model.IElementKind;

public interface IElementCriteria {
    public static final IElementCriteria CLASS_OR_MIXIN = new IElementCriteria(){};
    public static final IElementCriteria CLASS_OR_MIXIN_FRAGMENT = new IElementCriteria(){};

    public static class ByKind
    implements IElementCriteria {
        private final IElementKind kind;
        protected static final Map<IElementKind, ByKind> elementKindsToCriterias = new HashMap<IElementKind, ByKind>();
        public static final IElementCriteria MODEL;
        public static final IElementCriteria METHOD;
        public static final IElementCriteria CLASS;
        public static final IElementCriteria MIXIN;
        public static final IElementCriteria CLASS_FRAGMENT;
        public static final IElementCriteria MIXIN_FRAGMENT;
        public static final IElementCriteria LOCAL_VARIABLE;
        public static final IElementCriteria INSTANCE_VARIABLE;
        public static final IElementCriteria CLASS_VARIABLE;
        public static final IElementCriteria GLOBAL_VARIABLE;
        public static final IElementCriteria MIXIN_VARIABLE;
        public static final IElementCriteria ARGUMENT_VARIABLE;

        static {
            ByKind.add(IElementKind.MODEL);
            ByKind.add(IElementKind.CLASS);
            ByKind.add(IElementKind.MIXIN);
            ByKind.add(IElementKind.CLASS_FRAGMENT);
            ByKind.add(IElementKind.MIXIN_FRAGMENT);
            ByKind.add(IElementKind.METHOD);
            ByKind.add(IElementKind.GLOBAL_VARIABLE);
            ByKind.add(IElementKind.INSTANCE_VARIABLE);
            ByKind.add(IElementKind.CLASS_VARIABLE);
            ByKind.add(IElementKind.MIXIN_VARIABLE);
            ByKind.add(IElementKind.ARGUMENT_VARIABLE);
            MODEL = ByKind.byElementKind(IElementKind.MODEL);
            METHOD = ByKind.byElementKind(IElementKind.METHOD);
            CLASS = ByKind.byElementKind(IElementKind.CLASS);
            MIXIN = ByKind.byElementKind(IElementKind.MIXIN);
            CLASS_FRAGMENT = ByKind.byElementKind(IElementKind.CLASS_FRAGMENT);
            MIXIN_FRAGMENT = ByKind.byElementKind(IElementKind.MIXIN_FRAGMENT);
            LOCAL_VARIABLE = ByKind.byElementKind(IElementKind.LOCAL_VARIABLE);
            INSTANCE_VARIABLE = ByKind.byElementKind(IElementKind.INSTANCE_VARIABLE);
            CLASS_VARIABLE = ByKind.byElementKind(IElementKind.CLASS_VARIABLE);
            GLOBAL_VARIABLE = ByKind.byElementKind(IElementKind.GLOBAL_VARIABLE);
            MIXIN_VARIABLE = ByKind.byElementKind(IElementKind.MIXIN_VARIABLE);
            ARGUMENT_VARIABLE = ByKind.byElementKind(IElementKind.ARGUMENT_VARIABLE);
        }

        public ByKind(IElementKind kind) {
            this.kind = kind;
        }

        public IElementKind getKind() {
            return this.kind;
        }

        private static void add(IElementKind kind) {
            elementKindsToCriterias.put(kind, new ByKind(kind));
        }

        public static ByKind byElementKind(IElementKind kind) {
            return elementKindsToCriterias.get(kind);
        }
    }
}

