/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.tcl.ast.ArgumentMatch;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.definitions.Argument;
import org.eclipse.dltk.tcl.definitions.ArgumentType;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.ComplexArgument;
import org.eclipse.dltk.tcl.definitions.Constant;
import org.eclipse.dltk.tcl.definitions.DefinitionsFactory;
import org.eclipse.dltk.tcl.definitions.Group;
import org.eclipse.dltk.tcl.definitions.Switch;
import org.eclipse.dltk.tcl.definitions.TypedArgument;
import org.eclipse.dltk.tcl.parser.Messages;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionUtils;
import org.eclipse.dltk.tcl.parser.definitions.Info;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynopsisBuilder {
    private static final String NULL_SYNOPSIS = "";
    private static final String NULL_LINE = "...";
    private static final String NULL_ARG_DEFINITON_SYNOPSIS = "arg";
    private static final String NULL_TCL_ARGUMENT_SYNOPSIS = "none";
    private static final String ENDLESS_BOUNDS_END = " ...";
    private static final String POSSIBLE_START = "?";
    private static final String POSSIBLE_END = "?";
    private static final String SWITCH_START = "[";
    private static final String SWITCH_END = "]";
    private static final String SWITCH_SEPARATOR = "|";
    private static final String COMPLEX_ARGUMENT_START = "{";
    private static final String COMPLEX_ARGUMENT_END = "}";
    private static final String BOUNDS_START = "(";
    private static final String BOUNDS_END = ")";
    private static final String BOUNDS_SEPARATOR = "-";
    private static final String DEFINITION_SEPARATOR = " ";
    private static final String LINE_SEPARATOR = "\n";
    private static final String HTML_LINE_SEPARATOR = "<br/>";
    private static final String LIST_SEPARATOR = ",";
    private static final String HTML_CONST_START = "<b>";
    private static final String HTML_CONST_END = "</b>";
    private static final String HTML_ARGUMENT_START = "<i>";
    private static final String HTML_ARGUMENT_END = "</i>";
    private static final String CONST_START = "";
    private static final String CONST_END = "";
    private static final String ARGUMENT_START = "";
    private static final String ARGUMENT_END = "";
    private boolean asHtml;

    public SynopsisBuilder() {
        this(false);
    }

    public SynopsisBuilder(boolean asHtml) {
        this.asHtml = asHtml;
    }

    public String getSynopsis(Command command) {
        if (command == null) {
            return NULL_LINE;
        }
        Synopsis root = this.processCommand(command);
        return this.join(root.getSynopsis(), this.asHtml ? HTML_LINE_SEPARATOR : LINE_SEPARATOR);
    }

    public String getShortHint(TclCommand tclCommand) {
        if (tclCommand == null || tclCommand.getDefinition() == null) {
            return NULL_LINE;
        }
        Synopsis root = this.processCommand(tclCommand.getDefinition());
        return root.getShortHint(tclCommand, root);
    }

    private String join(List<String> strings, String delim) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String string : strings) {
            if (first) {
                first = false;
            } else {
                result.append(delim);
            }
            result.append(string);
        }
        return result.toString();
    }

    private Synopsis processCommand(Command command) {
        Synopsis root = this.processArgumentList((List<Argument>)command.getArguments(), 0);
        String commandName = new SynopsisConstant(command.getName()).toString();
        root.insert(commandName);
        return root;
    }

    private Synopsis processArgumentList(List<Argument> arguments, int pos) {
        Synopsis synopsis;
        if (pos >= arguments.size()) {
            Synopsis leaf = new Synopsis();
            if (arguments.size() != 0) {
                leaf.selector = arguments.get(0);
            }
            return leaf;
        }
        Argument argument = arguments.get(pos);
        if (argument instanceof Switch && (synopsis = this.processSubCommands(arguments, pos)) != null) {
            if (arguments.size() != 0) {
                synopsis.selector = arguments.get(0);
            }
            return synopsis;
        }
        StringBuilder prefix = new StringBuilder();
        prefix.append(this.definitionToString(argument, argument.getLowerBound(), argument.getUpperBound()));
        Synopsis synopsis2 = this.processArgumentList(arguments, pos + 1);
        synopsis2.insert(prefix.toString());
        return synopsis2;
    }

    private Synopsis processSubCommands(List<Argument> arguments, int pos) {
        Switch sw = (Switch)arguments.get(pos);
        if (DefinitionUtils.isOptions(sw) || DefinitionUtils.isMode(sw) || sw.getName() != null && sw.getName().length() > 0) {
            return null;
        }
        Synopsis synopsis = new Synopsis();
        if (sw.getLowerBound() == 0) {
            synopsis.children.add(new Synopsis());
        }
        for (Group group : sw.getGroups()) {
            Synopsis child;
            String cval = group.getConstant();
            if (cval != null && cval.length() > 0) {
                Constant c = DefinitionsFactory.eINSTANCE.createConstant();
                c.setName(cval);
                c.setName(cval);
                ArrayList<Argument> list = new ArrayList<Argument>();
                list.add(c);
                list.addAll((Collection<Argument>)group.getArguments());
                child = this.processArgumentList(list, 0);
            } else {
                child = this.processArgumentList((List<Argument>)group.getArguments(), 0);
            }
            synopsis.children.add(child);
        }
        return synopsis;
    }

    private String addBounds(String inner, int lower, int upper) {
        StringBuilder result = new StringBuilder();
        if (lower == 0) {
            if (upper == -1) {
                result.append("?").append(inner).append(ENDLESS_BOUNDS_END).append("?");
            } else if (upper <= 2) {
                boolean first = true;
                int i = 0;
                while (i < upper) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(DEFINITION_SEPARATOR);
                    }
                    result.append("?").append(inner).append("?");
                    ++i;
                }
            } else {
                result.append(inner).append(BOUNDS_START).append(lower).append(BOUNDS_SEPARATOR).append(upper).append(BOUNDS_END);
            }
        } else if (upper <= 2) {
            boolean first = true;
            int i = 0;
            while (i < lower) {
                if (first) {
                    first = false;
                } else {
                    result.append(DEFINITION_SEPARATOR);
                }
                result.append(inner);
                ++i;
            }
            if (upper == -1) {
                result.append(DEFINITION_SEPARATOR).append("?").append(inner).append(ENDLESS_BOUNDS_END).append("?");
            } else {
                i = 0;
                while (i < upper - lower) {
                    result.append(DEFINITION_SEPARATOR).append("?").append(inner).append("?");
                    ++i;
                }
            }
        } else {
            result.append(inner).append(BOUNDS_START).append(lower).append(BOUNDS_SEPARATOR).append(upper).append(BOUNDS_END);
        }
        return result.toString();
    }

    public String definitionToList(List<Argument> definitions) {
        if (definitions == null || definitions.size() == 0) {
            return "";
        }
        if (definitions.size() == 1) {
            return this.definitionToString(definitions.get(0));
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Argument definition : definitions) {
            String value = this.definitionToString(definition);
            if (list.contains(value)) continue;
            list.add(value);
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (first) {
                first = false;
            } else {
                result.append(LIST_SEPARATOR);
            }
            result.append(s);
        }
        return result.toString();
    }

    public String definitionToString(Argument argument, int lower, int upper) {
        if (argument == null) {
            return this.addBounds(new SynopsisArgument(NULL_ARG_DEFINITON_SYNOPSIS).toString(), lower, upper);
        }
        StringBuilder out = new StringBuilder();
        if (argument instanceof Constant) {
            out.append(new SynopsisConstant(((Constant)argument).getName()).toString());
        } else if (argument instanceof TypedArgument || argument.getName() != null && argument.getName().length() > 0) {
            out.append(new SynopsisArgument(argument.getName()).toString());
        } else if (argument instanceof Group) {
            boolean isInner;
            Group gr = (Group)argument;
            String inner = this.definitionToString((List<Argument>)gr.getArguments());
            String cval = gr.getConstant();
            boolean isConst = cval != null && cval.length() > 0;
            boolean bl = isInner = inner != null && inner.length() > 0;
            if (isConst && isInner) {
                out.append(new SynopsisConstant(cval).toString()).append(DEFINITION_SEPARATOR).append(inner);
            } else if (isConst) {
                out.append(new SynopsisConstant(cval).toString());
            } else if (isInner) {
                out.append(inner);
            }
        } else if (argument instanceof ComplexArgument) {
            ComplexArgument ca = (ComplexArgument)argument;
            out.append(COMPLEX_ARGUMENT_START).append(this.definitionToString((List<Argument>)ca.getArguments())).append(COMPLEX_ARGUMENT_END);
        } else if (argument instanceof Switch) {
            Switch sw = (Switch)argument;
            if (DefinitionUtils.isOptions(sw)) {
                boolean first = true;
                for (Group group : sw.getGroups()) {
                    if (first) {
                        first = false;
                    } else {
                        out.append(DEFINITION_SEPARATOR);
                    }
                    out.append("?").append(this.definitionToString(group, 1, 1)).append("?");
                }
                return out.toString();
            }
            if (DefinitionUtils.isMode(sw)) {
                boolean first = true;
                out.append(SWITCH_START);
                for (Group group : sw.getGroups()) {
                    if (first) {
                        first = false;
                    } else {
                        out.append(SWITCH_SEPARATOR);
                    }
                    out.append(this.definitionToString(group, 1, 1));
                }
                out.append(SWITCH_END);
                return this.addBounds(out.toString(), sw.getLowerBound(), sw.getUpperBound());
            }
            boolean first = true;
            out.append(SWITCH_START);
            for (Group group : sw.getGroups()) {
                if (first) {
                    first = false;
                } else {
                    out.append(SWITCH_SEPARATOR);
                }
                out.append(this.definitionToString(group, group.getLowerBound(), group.getUpperBound()));
            }
            out.append(SWITCH_END);
        } else {
            throw new IllegalArgumentException();
        }
        return this.addBounds(out.toString(), lower, upper);
    }

    public String definitionToString(List<Argument> definitions) {
        if (definitions == null || definitions.size() == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (Argument definition : definitions) {
            if (first) {
                first = false;
            } else {
                out.append(DEFINITION_SEPARATOR);
            }
            out.append(this.definitionToString(definition));
        }
        return out.toString();
    }

    public String definitionToString(Argument definition) {
        if (definition == null) {
            return NULL_ARG_DEFINITON_SYNOPSIS;
        }
        return this.definitionToString(definition, definition.getLowerBound(), definition.getUpperBound());
    }

    public String argumentToString(TclArgument argument) {
        if (argument == null) {
            return NULL_TCL_ARGUMENT_SYNOPSIS;
        }
        if (argument instanceof StringArgument) {
            return ((StringArgument)argument).getValue();
        }
        if (argument instanceof ComplexString) {
            ComplexString complexString = (ComplexString)argument;
            StringBuffer buffer = new StringBuffer();
            EList<TclArgument> arguments = complexString.getArguments();
            for (TclArgument tclArgument : arguments) {
                buffer.append(this.argumentToString(tclArgument));
            }
            return buffer.toString();
        }
        if (argument instanceof VariableReference) {
            return ((VariableReference)argument).getName();
        }
        if (argument instanceof Substitution) {
            return Messages.TclArgumentMatcher_Tcl_Substitution_Display;
        }
        return null;
    }

    public String typeToString(ArgumentType type) {
        switch (type) {
            case ANY: {
                return Info.TclArgumentType_Any;
            }
            case BOOLEAN: {
                return Info.TclArgumentType_Boolean;
            }
            case CMD_NAME: {
                return Info.TclArgumentType_CmdName;
            }
            case EXPRESSION: {
                return Info.TclArgumentType_Expression;
            }
            case INDEX: {
                return Info.TclArgumentType_Index;
            }
            case INTEGER: {
                return Info.TclArgumentType_Integer;
            }
            case LEVEL: {
                return Info.TclArgumentType_Level;
            }
            case NAMESPACE: {
                return Info.TclArgumentType_Namespace;
            }
            case NOT_NEGATIVE: {
                return Info.TclArgumentType_NotNegative;
            }
            case PACKAGE: {
                return Info.TclArgumentType_Package;
            }
            case SCRIPT: {
                return Info.TclArgumentType_Script;
            }
            case VAR_NAME: {
                return Info.TclArgumentType_VarName;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Synopsis {
        protected Argument selector;
        private List<Synopsis> children = new ArrayList<Synopsis>();
        private String string = null;

        public void insert(String prefix) {
            if (prefix == null || prefix.length() == 0) {
                return;
            }
            this.string = this.string == null ? prefix : String.valueOf(prefix) + SynopsisBuilder.DEFINITION_SEPARATOR + this.string;
        }

        private boolean matchArgument(Argument argument, Argument selector) {
            if (selector == null) {
                return false;
            }
            if (selector instanceof Switch) {
                for (Group group : ((Switch)selector).getGroups()) {
                    if (!this.matchArgument(argument, group)) continue;
                    return true;
                }
            } else if (selector instanceof Group) {
                Group group = (Group)selector;
                String cval = group.getConstant();
                if (cval != null && cval.length() > 0) {
                    Constant c = DefinitionsFactory.eINSTANCE.createConstant();
                    c.setName(cval);
                    return DefinitionUtils.equalsArgumentIgnoreName(c, argument);
                }
                if (group.getArguments().size() != 0) {
                    return DefinitionUtils.equalsArgumentIgnoreName((Argument)group.getArguments().get(0), argument);
                }
            } else if (selector instanceof ComplexArgument) {
                ComplexArgument complex = (ComplexArgument)selector;
                if (complex.getArguments().size() != 0) {
                    return DefinitionUtils.equalsArgumentIgnoreName((Argument)complex.getArguments().get(0), argument);
                }
            } else {
                return DefinitionUtils.equalsArgumentIgnoreName(selector, argument);
            }
            return false;
        }

        private List<Synopsis> matchPrefix(TclArgument tclArgument) {
            ArrayList<Synopsis> matched = new ArrayList<Synopsis>();
            if (!(tclArgument instanceof StringArgument)) {
                return matched;
            }
            String value = ((StringArgument)tclArgument).getValue();
            for (Synopsis child : this.children) {
                String cvalue;
                if (!(child.selector instanceof Constant) || (cvalue = ((Constant)child.selector).getName()) == null) continue;
                matched.add(child);
            }
            if (matched.size() == 0) {
                return matched;
            }
            ArrayList<Synopsis> notMatched = new ArrayList<Synopsis>();
            int i = 0;
            while (i < value.length()) {
                String c;
                if (matched.size() == 1 && value.equals(c = ((Constant)((Synopsis)matched.get((int)0)).selector).getName())) {
                    return matched;
                }
                for (Synopsis child : matched) {
                    String c2 = ((Constant)child.selector).getName();
                    if (c2.length() > i && value.charAt(i) == c2.charAt(i)) continue;
                    notMatched.add(child);
                }
                if (notMatched.size() != 0) {
                    matched.removeAll(notMatched);
                    notMatched.clear();
                }
                ++i;
            }
            return matched;
        }

        public boolean match(List<ArgumentMatch> matches) {
            for (ArgumentMatch match : matches) {
                if (!this.matchArgument(match.getDefinition(), this.selector)) continue;
                return true;
            }
            return false;
        }

        public String getShortHint(TclCommand tclCommand, Synopsis root) {
            if (this.children.size() == 0) {
                return this.string == null ? "" : this.string;
            }
            List<Synopsis> synopsises = null;
            StringBuilder result = new StringBuilder();
            if (tclCommand != null) {
                EList<ArgumentMatch> matches = tclCommand.getMatches();
                if (matches.size() == 0 && this == root && tclCommand.getArguments().size() != 0) {
                    synopsises = this.matchPrefix((TclArgument)tclCommand.getArguments().get(0));
                    if (synopsises.size() == 1) {
                        String subResult = synopsises.get(0).getShortHint(tclCommand, root);
                        if (this.string != null) {
                            result.append(this.string);
                        }
                        if (subResult.length() > 0) {
                            result.append(SynopsisBuilder.DEFINITION_SEPARATOR).append(subResult);
                        }
                        return result.toString();
                    }
                    if (synopsises.size() == 0) {
                        synopsises = this.children;
                    }
                } else {
                    synopsises = this.children;
                    for (Synopsis synopsis : synopsises) {
                        if (!synopsis.match((List<ArgumentMatch>)matches)) continue;
                        String subResult = synopsis.getShortHint(tclCommand, root);
                        if (this.string != null) {
                            result.append(this.string);
                        }
                        if (subResult.length() > 0) {
                            result.append(SynopsisBuilder.DEFINITION_SEPARATOR).append(subResult);
                        }
                        return result.toString();
                    }
                }
            } else {
                synopsises = this.children;
            }
            result.append(this.string);
            boolean first = true;
            for (Synopsis synopsis : synopsises) {
                if (first) {
                    result.append(SynopsisBuilder.DEFINITION_SEPARATOR).append(SynopsisBuilder.SWITCH_START);
                    first = false;
                } else {
                    result.append(SynopsisBuilder.SWITCH_SEPARATOR);
                }
                if (synopsis.string == null) {
                    result.append(SynopsisBuilder.NULL_LINE);
                    continue;
                }
                String[] words = synopsis.string.split(SynopsisBuilder.DEFINITION_SEPARATOR);
                result.append(words[0]);
                if (synopsis.children.size() == 0 && words.length <= 1) continue;
                result.append(SynopsisBuilder.ENDLESS_BOUNDS_END);
            }
            result.append(SynopsisBuilder.SWITCH_END);
            return result.toString();
        }

        public List<String> getSynopsis() {
            ArrayList<String> results = new ArrayList<String>();
            if (this.children.size() == 0) {
                results.add(this.string == null ? "" : this.string);
            }
            for (Synopsis child : this.children) {
                List<String> subResults = child.getSynopsis();
                if (subResults.size() == 0) {
                    results.add("");
                }
                for (String subResult : subResults) {
                    StringBuilder result = new StringBuilder();
                    if (this.string != null) {
                        result.append(this.string);
                    }
                    if (subResult.length() > 0) {
                        result.append(SynopsisBuilder.DEFINITION_SEPARATOR).append(subResult);
                    }
                    results.add(result.toString());
                }
            }
            return results;
        }
    }

    private class SynopsisArgument
    extends SynopsisWord {
        public SynopsisArgument(String word) {
            super(word, SynopsisBuilder.this.asHtml ? SynopsisBuilder.HTML_ARGUMENT_START : "", SynopsisBuilder.this.asHtml ? SynopsisBuilder.HTML_ARGUMENT_END : "");
        }
    }

    private class SynopsisConstant
    extends SynopsisWord {
        public SynopsisConstant(String word) {
            super(word, SynopsisBuilder.this.asHtml ? SynopsisBuilder.HTML_CONST_START : "", SynopsisBuilder.this.asHtml ? SynopsisBuilder.HTML_CONST_END : "");
        }
    }

    private class SynopsisWord {
        private String word;
        private String start;
        private String end;

        public SynopsisWord(String word, String start, String end) {
            this.word = word;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.start);
            result.append(this.word);
            result.append(this.end);
            return result.toString();
        }
    }
}

