/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.osgi.framework.Bundle;

public class CoreUtility {
    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                CoreUtility.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        String pluginId = element.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static boolean enableAutoBuild(boolean state) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != state) {
            desc.setAutoBuilding(state);
            workspace.setDescription(desc);
        }
        return isAutoBuilding;
    }

    public static Job getBuildJob(IProject project) {
        BuildJob buildJob = new BuildJob(DLTKUIMessages.CoreUtility_job_title, project);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    private static final class BuildJob
    extends Job {
        private final IProject fProject;

        public BuildJob(String name, IProject project) {
            super(name);
            this.fProject = project;
        }

        public boolean isCoveredBy(BuildJob other) {
            if (other.fProject == null) {
                return true;
            }
            return this.fProject != null && this.fProject.equals((Object)other.fProject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int i = 0;
                while (i < buildJobs.length) {
                    BuildJob job;
                    Job curr = buildJobs[i];
                    if (curr != this && curr instanceof BuildJob && (job = (BuildJob)curr).isCoveredBy(this)) {
                        curr.cancel();
                    }
                    ++i;
                }
            }
            try {
                try {
                    if (this.fProject != null) {
                        monitor.beginTask(Messages.format(DLTKUIMessages.CoreUtility_buildproject_taskname, this.fProject.getName()), 2);
                        this.fProject.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        DLTKUIPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.beginTask(DLTKUIMessages.CoreUtility_buildall_taskname, 2);
                        DLTKUIPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

