/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.console.ConsoleRequest;
import org.eclipse.dltk.console.SocketScriptConsoleIO;

public class ScriptConsoleServer
implements Runnable {
    public static final int DEFAULT_PORT = 25000;
    protected static final boolean DEBUG = false;
    private static ScriptConsoleServer instance;
    private int port = 25000;
    private final Map<String, ConsoleRequest> handlers;

    public static synchronized ScriptConsoleServer getInstance() {
        if (instance == null) {
            instance = new ScriptConsoleServer();
        }
        return instance;
    }

    protected ScriptConsoleServer() {
        while (true) {
            try {
                ServerSocket s;
                while (!(s = new ServerSocket(this.port)).isBound()) {
                    ++this.port;
                }
                s.close();
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        this.handlers = new HashMap<String, ConsoleRequest>();
        new Thread(this).start();
    }

    public String register(ConsoleRequest request) {
        String id = Long.valueOf(System.currentTimeMillis()).toString();
        this.register(id, request);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String id, ConsoleRequest request) {
        Map<String, ConsoleRequest> map = this.handlers;
        synchronized (map) {
            this.handlers.put(id, request);
            this.handlers.notifyAll();
        }
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        try {
            ServerSocket server = new ServerSocket(this.port);
            while (true) {
                Socket client = server.accept();
                client.setSoTimeout(30000);
                Thread clientHandler = new Thread(() -> {
                    try {
                        SocketScriptConsoleIO proxy = new SocketScriptConsoleIO(client);
                        String id = proxy.getId();
                        ConsoleRequest request = null;
                        Map<String, ConsoleRequest> map = this.handlers;
                        synchronized (map) {
                            request = this.handlers.get(id);
                            while (request == null) {
                                try {
                                    this.handlers.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            this.handlers.remove(id);
                        }
                        request.consoleConnected(proxy);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                clientHandler.start();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }
}

