/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.net4j.util.collection.IHistory;
import org.eclipse.net4j.util.ui.widgets.HistoryText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HistoryTextDialog
extends InputDialog {
    private static final String EMPTY = "";
    private IHistory<String> history;
    private String value = "";
    private HistoryText historyText;

    public HistoryTextDialog(Shell parentShell, String dialogTitle, String dialogMessage, IHistory<String> history, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, (String)history.getMostRecent(), validator);
        this.history = history;
        this.value = super.getValue();
    }

    public IHistory<String> getHistory() {
        return this.history;
    }

    public HistoryText getHistoryText() {
        return this.historyText;
    }

    public String getValue() {
        return this.value;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Text text = this.getText();
        text.setVisible(false);
        text.setEnabled(false);
        this.historyText = new HistoryText(composite, 2048, this.history);
        this.historyText.getCombo().moveAbove((Control)text);
        this.historyText.getCombo().setLayoutData((Object)new GridData(768));
        this.historyText.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HistoryTextDialog.this.validateInput();
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                HistoryTextDialog.this.historyText.setFocus();
            }
        });
        composite.getShell().layout(true);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.historyText.getText();
            this.okPressed();
        } else if (1 == buttonId) {
            this.value = null;
            this.cancelPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.historyText.setFocus();
        if (this.value != null) {
            this.historyText.setText(this.value);
        }
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.getValidator() != null) {
            errorMessage = this.getValidator().isValid(this.historyText.getText());
        }
        this.setErrorMessage(errorMessage);
    }
}

