/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.extended;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.ui.dialogs.PropertiesDialog;
import org.eclipse.gmf.runtime.common.ui.services.properties.ICompositePropertySource;
import org.eclipse.gmf.runtime.common.ui.services.properties.PropertiesService;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.ElementValue;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.IExtendedPropertySource;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.IPropertyAction;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.MultiButtonCellEditor;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.PropertyPagePropertyDescriptor;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertyPageCellEditor
extends MultiButtonCellEditor {
    private final PropertyPagePropertyDescriptor propertyDescriptor;

    public PropertyPageCellEditor(Composite parent, PropertyPagePropertyDescriptor descriptor) {
        this(parent, descriptor, 0);
    }

    public PropertyPageCellEditor(Composite parent, PropertyPagePropertyDescriptor descriptor, int style) {
        super(parent, style);
        this.propertyDescriptor = descriptor;
    }

    private PropertyPagePropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Object element;
        PropertiesDialog dialog = new PropertiesDialog(this.getControl().getShell(), new PreferenceManager());
        PropertyPagePropertyDescriptor realDescriptor = null;
        if (this.getValue() instanceof ElementValue && (element = ((ElementValue)this.getValue()).getElement()) instanceof PropertyPagePropertyDescriptor) {
            realDescriptor = (PropertyPagePropertyDescriptor)element;
        }
        List pages = null;
        pages = realDescriptor != null ? realDescriptor.createPropertyPages() : this.getPropertyDescriptor().createPropertyPages();
        for (PropertyPage page : pages) {
            if (realDescriptor != null) {
                final IPropertySource source = realDescriptor.getPropertySource();
                page.setElement(new IAdaptable(){

                    public Object getAdapter(Class adapter) {
                        if (adapter.equals(IPropertySource.class)) {
                            return source;
                        }
                        return null;
                    }
                });
            }
            dialog.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("", (IPreferencePage)page));
        }
        dialog.create();
        dialog.open();
        block1: for (PropertyPage page : pages) {
            IPropertySource source;
            IAdaptable adaptable = page.getElement();
            if (adaptable == null || !((source = (IPropertySource)adaptable.getAdapter(IPropertySource.class)) instanceof IExtendedPropertySource)) continue;
            Object element2 = ((IExtendedPropertySource)source).getElement();
            ICompositePropertySource propertySource = PropertiesService.getInstance().getPropertySource(element2);
            assert (propertySource != null);
            for (IPropertyDescriptor descriptor : Arrays.asList(propertySource.getPropertyDescriptors())) {
                if (!descriptor.getId().equals(this.getPropertyDescriptor().getId())) continue;
                this.setValue(new ElementValue(source, propertySource.getPropertyValue(descriptor.getId())));
                this.fireApplyEditorValue();
                continue block1;
            }
        }
        return null;
    }

    public boolean isCopyEnabled() {
        return false;
    }

    public boolean isCutEnabled() {
        return false;
    }

    public boolean isDeleteEnabled() {
        return false;
    }

    public boolean isPasteEnabled() {
        return false;
    }

    public boolean isSaveAllEnabled() {
        return false;
    }

    public boolean isSelectAllEnabled() {
        return false;
    }

    public void performCopy() {
    }

    public void performCut() {
    }

    public void performDelete() {
    }

    public void performPaste() {
    }

    public void performSelectAll() {
    }

    protected Object getCellObjectValue() {
        return super.doGetValue();
    }

    @Override
    protected void initButtons() {
        IPropertyAction setAction = new IPropertyAction(){

            @Override
            public Object execute(Control owner) {
                return PropertyPageCellEditor.this.openDialogBox(owner);
            }
        };
        this.addButton("...", setAction);
    }
}

