/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.ui.actions.ILaunchable;

public class LaunchablePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("launchable".equals(property) && DebugUIPlugin.getDefault().getLaunchConfigurationManager().launchModeAvailable((String)expectedValue)) {
            return Platform.getAdapterManager().hasAdapter(receiver, ILaunchable.class.getName());
        }
        if ("contextlaunch".equals(property) && DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.UseContextualLaunch")) {
            IResource res = this.getResource(receiver);
            if (res != null) {
                return res.isAccessible() && this.getLaunchConfigurationManager().getLaunchShortcuts(this.getResource(receiver)).size() > 0 && this.getLaunchConfigurationManager().isSharedConfig(receiver) == null;
            }
            return false;
        }
        return false;
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    protected IResource getResource(Object element) {
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return resource;
    }
}

