/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.provider;

import java.io.OutputStream;
import java.util.Optional;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.connector.Logger;
import org.eclipse.terminal.connector.TerminalState;

public abstract class AbstractTerminalConnector {
    protected ITerminalControl fControl;

    public void initialize() throws Exception {
    }

    public void connect(ITerminalControl control) {
        Logger.log("entered.");
        this.fControl = control;
    }

    public final void disconnect() {
        Logger.log("entered.");
        this.doDisconnect();
        this.fControl.setState(TerminalState.CLOSED);
    }

    protected void doDisconnect() {
    }

    public abstract OutputStream getTerminalToRemoteStream();

    public abstract String getSettingsSummary();

    public boolean isLocalEcho() {
        return false;
    }

    public void setDefaultSettings() {
    }

    public void load(ISettingsStore store) {
    }

    public void save(ISettingsStore store) {
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }

    public Optional<String> getWorkingDirectory() {
        return Optional.empty();
    }
}

