/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.spliterator;

import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class WrappingSpliterator<T extends IJavaElement>
implements Spliterator<T> {
    private final List<? extends JavaElementSpi> m_spiList;
    private int m_end;
    private int m_pos;

    public WrappingSpliterator(List<? extends JavaElementSpi> spiList) {
        this(spiList, 0, spiList.size());
    }

    public WrappingSpliterator(List<? extends JavaElementSpi> spiList, int offset, int end) {
        Ensure.instanceOf(spiList, RandomAccess.class);
        this.m_spiList = spiList;
        this.m_pos = offset;
        this.m_end = end;
    }

    public static <X extends IJavaElement> Stream<X> stream(List<? extends JavaElementSpi> spiList) {
        return StreamSupport.stream(new WrappingSpliterator(spiList), false);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.m_pos >= this.m_end) {
            return false;
        }
        action.accept(this.currentElement());
        this.moveToNext();
        return true;
    }

    protected T currentElement() {
        return this.element(this.m_pos);
    }

    protected T element(int index) {
        return (T)this.m_spiList.get(index).wrap();
    }

    protected void moveToNext() {
        ++this.m_pos;
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.estimateSize();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        for (int i = this.m_pos; i < this.m_end; ++i) {
            action.accept(this.element(i));
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        int split = (this.m_end - this.m_pos) / 2;
        if (split < 1) {
            return null;
        }
        int firstForSplit = this.m_pos + split;
        WrappingSpliterator<T> result = new WrappingSpliterator<T>(this.m_spiList, firstForSplit, this.m_end);
        this.m_end = firstForSplit;
        return result;
    }

    @Override
    public long estimateSize() {
        return this.m_end - this.m_pos;
    }

    @Override
    public int characteristics() {
        return 17745;
    }
}

