/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.builder;

import java.util.Optional;
import org.eclipse.scout.sdk.core.builder.BuilderContext;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.typescript.builder.ITypeScriptBuilderContext;
import org.eclipse.scout.sdk.core.typescript.builder.imports.ES6ImportValidator;
import org.eclipse.scout.sdk.core.typescript.builder.imports.IES6ImportValidator;
import org.eclipse.scout.sdk.core.util.PropertySupport;

public class TypeScriptBuilderContext
implements ITypeScriptBuilderContext {
    private final IBuilderContext m_inner;
    private final ES6ImportValidator m_validator;

    public TypeScriptBuilderContext(IBuilderContext context) {
        this.m_inner = Optional.ofNullable(context).orElseGet(BuilderContext::new);
        this.m_validator = new ES6ImportValidator();
    }

    public IBuilderContext builderContext() {
        return this.m_inner;
    }

    public String lineDelimiter() {
        return this.builderContext().lineDelimiter();
    }

    public PropertySupport properties() {
        return this.builderContext().properties();
    }

    @Override
    public IES6ImportValidator importValidator() {
        return this.m_validator;
    }
}

