/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.ITMScope;

public final class TMScope
implements ITMScope {
    private final @Nullable String pluginId;
    private final String name;
    private final String qualifiedName;

    public static String toUnqualified(String scopeName) {
        int separatorAt = scopeName.indexOf(64);
        if (separatorAt == -1) {
            return scopeName;
        }
        return scopeName.substring(0, separatorAt);
    }

    public static TMScope parse(String scopeName) {
        int separatorAt = scopeName.indexOf(64);
        return separatorAt == -1 ? new TMScope(scopeName, null, scopeName) : new TMScope(scopeName.substring(0, separatorAt), scopeName.substring(separatorAt + 1), scopeName);
    }

    public TMScope(String scopeName, @Nullable String pluginId) {
        this.name = scopeName;
        this.pluginId = pluginId;
        this.qualifiedName = pluginId == null ? scopeName : scopeName + "@" + pluginId;
    }

    private TMScope(String scopeName, @Nullable String pluginId, String qualifiedName) {
        this.name = scopeName;
        this.pluginId = pluginId;
        this.qualifiedName = qualifiedName;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TMScope) {
            TMScope other = (TMScope)obj;
            if (this.qualifiedName.equals(other.qualifiedName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public @Nullable String getPluginId() {
        return this.pluginId;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    @Override
    public boolean isQualified() {
        return this.pluginId != null;
    }

    public String toString() {
        return this.qualifiedName;
    }
}

