/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jenkins.core.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.HTML;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.cookie.Cookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.core.HtmlTag;
import org.eclipse.mylyn.commons.core.HtmlUtil;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationException;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpOperation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsException;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsLoginForm;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsResourceNotFoundException;
import org.eclipse.osgi.util.NLS;

public abstract class JenkinsOperation<T>
extends CommonHttpOperation<T> {
    private static final String CRUMB_REGEX = ".*?\"crumb\":\\s*\"([a-zA-Z0-9]*)\".*\"crumbRequestField\":.*?\"(.*)\"";
    private static final String AUTHORIZATION_BASIC_TYPE = "Basic ";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String JSESSIONID = "JSESSIONID";
    private static final String ID_CONTEXT_CRUMB = ".crumb";
    private static final String ID_CONTEXT_CRUMB_HEADER = ".crumbHeader";
    private static final String AUTHENTICATION_FAILED = "Authentication failed";
    private static final String AUTHENTICATION_REQUESTED_WITHOUT_VALID_CREDENTIALS = "Authentication requested without valid credentials";

    public JenkinsOperation(CommonHttpClient client) {
        super(client);
    }

    protected String baseUrl() {
        Object url = this.getClient().getLocation().getUrl();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    protected void authenticate(IOperationMonitor monitor) throws IOException {
        block17: {
            this.getClient().setAuthenticated(false);
            this.getClient().clearAttributes();
            UserCredentials credentials = (UserCredentials)this.getClient().getLocation().getCredentials(AuthenticationType.REPOSITORY);
            if (credentials == null) {
                throw new IllegalStateException(AUTHENTICATION_REQUESTED_WITHOUT_VALID_CREDENTIALS);
            }
            HttpGet request = this.createGetRequest(this.baseUrl() + "crumbIssuer/api/json");
            HttpResponse response = this.getClient().execute((HttpRequestBase)request, monitor);
            try {
                if (response.getStatusLine().getStatusCode() == 200) {
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (InputStream inStream = HttpUtil.getResponseBodyAsStream((HttpEntity)response.getEntity(), (IProgressMonitor)monitor);){
                        String charSet = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
                        String text = IOUtils.toString((InputStream)inStream, (Charset)(charSet != null ? Charset.forName(charSet) : Charset.defaultCharset()));
                        Pattern crumbPattern = Pattern.compile(CRUMB_REGEX);
                        Matcher matcher = crumbPattern.matcher(text);
                        if (matcher.find()) {
                            String crumb = matcher.group(1);
                            String crumbHeader = matcher.group(2);
                            this.getClient().setAuthenticated(true);
                            this.getClient().setAttribute(ID_CONTEXT_CRUMB, (Object)crumb);
                            this.getClient().setAttribute(ID_CONTEXT_CRUMB_HEADER, (Object)crumbHeader);
                            break block17;
                        }
                        throw new AuthenticationException(AUTHENTICATION_FAILED, new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (response.getStatusLine().getStatusCode() >= 500) {
                    throw new AuthenticationException(response.getStatusLine().getReasonPhrase(), new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY));
                }
                if (response.getStatusLine().getStatusCode() == 404) {
                    this.legacyAuthentication(monitor, credentials);
                    break block17;
                }
                this.validate(response, monitor);
                throw new AuthenticationException(AUTHENTICATION_FAILED, new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY));
            }
            finally {
                HttpUtil.release((HttpRequest)request, (HttpResponse)response, (IProgressMonitor)monitor);
            }
        }
    }

    @Deprecated
    private void legacyAuthentication(IOperationMonitor monitor, UserCredentials credentials) throws UnsupportedEncodingException, IOException, AuthenticationException {
        HttpPost request = this.createPostRequest(this.baseUrl() + "j_acegi_security_check");
        HttpResponse response = this.executeAuthenticationRequest(monitor, credentials, request);
        try {
            if (response.getStatusLine().getStatusCode() == 404) {
                HttpUtil.release((HttpRequest)request, (HttpResponse)response, (IProgressMonitor)monitor);
                request = this.createPostRequest(this.baseUrl() + "j_spring_security_check");
                response = this.executeAuthenticationRequest(monitor, credentials, request);
            }
            this.validate(response, monitor);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 302) {
                this.getClient().setAuthenticated(false);
                System.err.println(EntityUtils.toString((HttpEntity)response.getEntity()));
                throw new IOException(NLS.bind((String)"Unexpected response from server while logging in: {0}", (Object)HttpUtil.getStatusText((int)statusCode)));
            }
            Header header = response.getFirstHeader("Location");
            if (header != null && header.getValue().endsWith("/loginError")) {
                this.getClient().setAuthenticated(false);
                throw new AuthenticationException(AUTHENTICATION_FAILED, new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY));
            }
            this.getClient().setAuthenticated(this.hasValidatAuthenticationState());
            this.updateCrumb(monitor);
        }
        finally {
            HttpUtil.release((HttpRequest)request, (HttpResponse)response, (IProgressMonitor)monitor);
        }
    }

    @Deprecated
    private HttpResponse executeAuthenticationRequest(IOperationMonitor monitor, UserCredentials credentials, HttpPost request) throws UnsupportedEncodingException, IOException {
        JenkinsLoginForm form = new JenkinsLoginForm();
        form.j_username = credentials.getUserName();
        form.j_password = credentials.getPassword();
        form.from = "";
        request.setEntity((HttpEntity)form.createEntity());
        HttpResponse response = this.getClient().execute((HttpRequestBase)request, monitor);
        return response;
    }

    @Deprecated
    private void updateCrumb(IOperationMonitor monitor) throws IOException {
        HttpGet request = super.createGetRequest(this.baseUrl());
        HttpResponse response = this.getClient().execute((HttpRequestBase)request, monitor);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream in = HttpUtil.getResponseBodyAsStream((HttpEntity)response.getEntity(), (IProgressMonitor)monitor);){
                try {
                    String charSet = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, charSet != null ? charSet : "UTF-8"));){
                        HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                            HtmlTag tag;
                            if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.SCRIPT) {
                                String text = HtmlUtil.getTextContent((HtmlStreamTokenizer)tokenizer);
                                Pattern pattern = Pattern.compile("crumb.init\\(\".*\",\\s*\"([a-zA-Z0-9]*)\"\\)");
                                Matcher matcher = pattern.matcher(text);
                                if (matcher.find()) {
                                    HttpContext context = this.getClient().getContext();
                                    String crumb = matcher.group(1);
                                    this.getClient().setAttribute(ID_CONTEXT_CRUMB, (Object)crumb);
                                    context.setAttribute(ID_CONTEXT_CRUMB_HEADER, (Object)ID_CONTEXT_CRUMB);
                                    break;
                                }
                            }
                            token = tokenizer.nextToken();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            HttpUtil.release((HttpRequest)request, (HttpResponse)response, (IProgressMonitor)monitor);
        }
    }

    public T run() throws JenkinsException {
        try {
            return this.execute();
        }
        catch (IOException | JAXBException e) {
            throw new JenkinsException(e);
        }
    }

    protected T doProcess(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, JenkinsException, JAXBException {
        return null;
    }

    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, JenkinsException {
        this.validate(response, 200, monitor);
    }

    protected abstract T execute() throws IOException, JenkinsException, JAXBException;

    protected T process(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, JenkinsException, JAXBException {
        try {
            this.doValidate(response, monitor);
            return this.doProcess(response, monitor);
        }
        catch (IOException | RuntimeException | JAXBException | JenkinsException e) {
            response.release();
            throw e;
        }
    }

    protected HttpGet createGetRequest(String requestPath) {
        HttpGet request = super.createGetRequest(requestPath);
        this.setupAuthentication((HttpRequestBase)request);
        return request;
    }

    protected HttpPost createPostRequest(String requestPath) {
        HttpPost request = super.createPostRequest(requestPath);
        this.setupAuthentication((HttpRequestBase)request);
        return request;
    }

    private void setupAuthentication(HttpRequestBase request) {
        UserCredentials credentials;
        String crumb = (String)this.getClient().getAttribute(ID_CONTEXT_CRUMB);
        if (crumb != null && !crumb.isEmpty()) {
            String crumbHeader = (String)this.getClient().getAttribute(ID_CONTEXT_CRUMB_HEADER);
            request.addHeader(crumbHeader, crumb);
        }
        if ((credentials = (UserCredentials)this.getClient().getLocation().getCredentials(AuthenticationType.REPOSITORY)) != null) {
            String encodedCreds = AUTHORIZATION_BASIC_TYPE + Base64.getEncoder().encodeToString((credentials.getUserName() + ":" + credentials.getPassword()).getBytes());
            request.addHeader(AUTHORIZATION_HEADER, encodedCreds);
        }
    }

    protected T processAndRelease(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, JenkinsException, JAXBException {
        try {
            this.doValidate(response, monitor);
            T t = this.doProcess(response, monitor);
            return t;
        }
        finally {
            response.release();
        }
    }

    protected void validate(CommonHttpResponse response, int expected, IOperationMonitor monitor) throws JenkinsException {
        int statusCode = response.getStatusCode();
        if (statusCode != expected) {
            if (statusCode == 404) {
                throw new JenkinsResourceNotFoundException(NLS.bind((String)"Requested resource ''{0}'' does not exist", (Object)response.getRequestPath()));
            }
            throw new JenkinsException(NLS.bind((String)"Unexpected response from Hudson server for ''{0}'': {1}", (Object)response.getRequestPath(), (Object)HttpUtil.getStatusText((int)statusCode)));
        }
    }

    protected boolean needsAuthentication() {
        if (this.hasCredentials()) {
            boolean authenticated = this.getClient().isAuthenticated() && this.getClient().getAttribute(ID_CONTEXT_CRUMB) != null && this.hasValidatAuthenticationState();
            return !authenticated;
        }
        return false;
    }

    private boolean hasCredentials() {
        return this.getClient().getLocation().getCredentials(AuthenticationType.REPOSITORY, false) != null;
    }

    private boolean hasValidatAuthenticationState() {
        ArrayList cookies = new ArrayList(this.getClient().getHttpClient().getCookieStore().getCookies());
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!JSESSIONID.equals(cookie.getName()) && !cookie.getName().startsWith(JSESSIONID)) continue;
                boolean expired = cookie.isExpired(new Date());
                return !expired;
            }
        }
        return false;
    }

    protected void validate(HttpResponse response, IOperationMonitor monitor) throws AuthenticationException {
        super.validate(response, monitor);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 403) {
            AuthenticationRequest request = new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY);
            throw new AuthenticationException(HttpUtil.getStatusText((int)statusCode), request, true);
        }
    }
}

