/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.platform.commons.util.Preconditions;

class EvaluatedArgumentSet {
    private final @Nullable Object[] all;
    private final @Nullable Object[] consumed;
    private final Optional<String> name;

    static EvaluatedArgumentSet allOf(Arguments arguments) {
        @Nullable Object[] all = arguments.get();
        return EvaluatedArgumentSet.create(all, all, arguments);
    }

    static EvaluatedArgumentSet of(Arguments arguments, IntUnaryOperator consumedLengthComputer) {
        @Nullable Object[] all = arguments.get();
        @Nullable Object[] consumed = EvaluatedArgumentSet.dropSurplus(all, consumedLengthComputer.applyAsInt(all.length));
        return EvaluatedArgumentSet.create(all, consumed, arguments);
    }

    private static EvaluatedArgumentSet create(@Nullable Object[] all, @Nullable Object[] consumed, Arguments arguments) {
        return new EvaluatedArgumentSet(all, consumed, EvaluatedArgumentSet.determineName(arguments));
    }

    private EvaluatedArgumentSet(@Nullable Object[] all, @Nullable Object[] consumed, Optional<String> name) {
        this.all = all;
        this.consumed = consumed;
        this.name = name;
    }

    int getTotalLength() {
        return this.all.length;
    }

    @Nullable Object[] getAllPayloads() {
        return EvaluatedArgumentSet.extractFromNamed(this.all, Named::getPayload);
    }

    int getConsumedLength() {
        return this.consumed.length;
    }

    @Nullable Object[] getConsumedArguments() {
        return this.consumed;
    }

    @Nullable Object[] getConsumedPayloads() {
        return EvaluatedArgumentSet.extractFromNamed(this.consumed, Named::getPayload);
    }

    @Nullable Object getConsumedPayload(int index) {
        return EvaluatedArgumentSet.extractFromNamed(this.consumed[index], Named::getPayload);
    }

    Optional<String> getName() {
        return this.name;
    }

    private static @Nullable Object[] dropSurplus(@Nullable Object[] arguments, int newLength) {
        Preconditions.condition((newLength <= arguments.length ? 1 : 0) != 0, () -> "New length %d must be less than or equal to the total length %d".formatted(newLength, arguments.length));
        return arguments.length > newLength ? Arrays.copyOf(arguments, newLength) : arguments;
    }

    private static Optional<String> determineName(Arguments arguments) {
        if (arguments instanceof Arguments.ArgumentSet) {
            Arguments.ArgumentSet set = (Arguments.ArgumentSet)arguments;
            return Optional.of(set.getName());
        }
        return Optional.empty();
    }

    private static @Nullable Object[] extractFromNamed(@Nullable Object[] arguments, Function<Named<?>, @Nullable Object> mapper) {
        return Arrays.stream(arguments).map(argument -> EvaluatedArgumentSet.extractFromNamed(argument, mapper)).toArray();
    }

    private static @Nullable Object extractFromNamed(@Nullable Object argument, Function<Named<?>, @Nullable Object> mapper) {
        Object object;
        if (argument instanceof Named) {
            Named named = (Named)argument;
            object = mapper.apply(named);
        } else {
            object = argument;
        }
        return object;
    }
}

