/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.templates;

import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class AntContext
extends DocumentTemplateContext {
    private final IAntModel fAntModel;

    public AntContext(TemplateContextType type, IDocument document, IAntModel model, Position position) {
        super(type, document, position);
        this.fAntModel = model;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateBuffer templateBuffer = this.createTemplateBuffer(template);
        if (templateBuffer == null) {
            return null;
        }
        return templateBuffer;
    }

    private TemplateBuffer createTemplateBuffer(Template template) throws BadLocationException, TemplateException {
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
        Document document = new Document(template.getPattern());
        AntContext.convertLineDelimiters((IDocument)document, lineDelimiter);
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(document.get());
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private static void convertLineDelimiters(IDocument document, String defaultLineDelimiter) throws BadLocationException {
        int lines = document.getNumberOfLines();
        int line = 0;
        while (line < lines) {
            IRegion region = document.getLineInformation(line);
            String lineDelimiter = document.getLineDelimiter(line);
            if (lineDelimiter != null) {
                document.replace(region.getOffset() + region.getLength(), lineDelimiter.length(), defaultLineDelimiter);
            }
            ++line;
        }
    }

    public IAntModel getAntModel() {
        return this.fAntModel;
    }

    public int getEnd() {
        int start = this.getCompletionOffset();
        int length = this.getCompletionLength();
        IDocument document = this.getDocument();
        if (start > 0 && document.get().charAt(start - 1) == '<' && document.getLength() > 1) {
            ++length;
        }
        int end = this.getCompletionOffset() + length;
        try {
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return end;
    }

    public int getStart() {
        int replacementOffset = this.getCompletionOffset();
        if (replacementOffset > 0 && this.getDocument().get().charAt(replacementOffset - 1) == '<') {
            --replacementOffset;
        }
        return replacementOffset;
    }
}

