/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class CompareFileRevisionEditorInput
extends SaveableCompareEditorInput {
    private final ITypedElement left;
    private final ITypedElement right;
    CompareInputChangeNotifier notifier = new CompareInputChangeNotifier(){

        @Override
        protected IResource[] getResources(ICompareInput input) {
            IResource resource = CompareFileRevisionEditorInput.this.getResource(input);
            if (resource == null) {
                return new IResource[0];
            }
            return new IResource[]{resource};
        }
    };

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CompareFileRevisionEditorInput) {
            CompareFileRevisionEditorInput other = (CompareFileRevisionEditorInput)((Object)obj);
            return other.getLeft().equals(this.left) && other.getRightRevision().equals(this.right);
        }
        return false;
    }

    public CompareFileRevisionEditorInput(ITypedElement left, ITypedElement right, IWorkbenchPage page) {
        super(new CompareConfiguration(), page);
        this.left = left;
        this.right = right;
        this.setTitle(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object)left.getName()));
    }

    @Override
    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICompareInput input = this.createCompareInput();
        this.getCompareConfiguration().setLeftEditable(this.isLeftEditable(input));
        this.getCompareConfiguration().setRightEditable(false);
        CompareFileRevisionEditorInput.ensureContentsCached(this.getLeftRevision(), this.getRightRevision(), monitor);
        this.initLabels(input);
        return input;
    }

    protected FileRevisionTypedElement getRightRevision() {
        if (this.right instanceof FileRevisionTypedElement) {
            return (FileRevisionTypedElement)this.right;
        }
        return null;
    }

    protected FileRevisionTypedElement getLeftRevision() {
        if (this.left instanceof FileRevisionTypedElement) {
            return (FileRevisionTypedElement)this.left;
        }
        return null;
    }

    private static void ensureContentsCached(FileRevisionTypedElement left, FileRevisionTypedElement right, IProgressMonitor monitor) {
        if (left != null) {
            try {
                left.cacheContents(monitor);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        if (right != null) {
            try {
                right.cacheContents(monitor);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
    }

    private boolean isLeftEditable(ICompareInput input) {
        ITypedElement left = input.getLeft();
        if (left instanceof IEditableContent) {
            return ((IEditableContent)left).isEditable();
        }
        return false;
    }

    private IResource getResource(ICompareInput input) {
        LocalResourceTypedElement localElement = this.getLocalElement();
        if (localElement != null) {
            return localElement.getResource();
        }
        return null;
    }

    private ICompareInput createCompareInput() {
        MyDiffNode input = new MyDiffNode(this.left, this.right);
        return input;
    }

    private void initLabels(ICompareInput input) {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.getLeftRevision() != null) {
            leftLabel = this.getFileRevisionLabel(this.getLeftRevision());
            cc.setLeftLabel(leftLabel);
        } else if (this.left instanceof LocalResourceTypedElement) {
            String name = TextProcessor.process((String)input.getLeft().getName());
            String leftLabel = this.getLocalResourceRevisionLabel((LocalResourceTypedElement)this.left, name);
            cc.setLeftLabel(leftLabel);
        } else if (this.getResource(input) != null) {
            leftLabel = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace, (Object[])new Object[]{TextProcessor.process((String)input.getLeft().getName())});
            cc.setLeftLabel(leftLabel);
        }
        if (this.getRightRevision() != null) {
            String rightLabel = this.getFileRevisionLabel(this.getRightRevision());
            cc.setRightLabel(rightLabel);
        }
    }

    private String getLocalResourceRevisionLabel(LocalResourceTypedElement localElement, String name) {
        if (Utils.isShowAuthor()) {
            String author = localElement.getAuthor();
            if (author == null) {
                try {
                    localElement.fetchAuthor(null);
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
                author = localElement.getAuthor();
            }
            if (author != null) {
                return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace_authorExists, (Object[])new Object[]{name, author});
            }
        }
        return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace, (Object[])new Object[]{name});
    }

    private String getFileRevisionLabel(FileRevisionTypedElement element) {
        IFileRevision fileObject = element.getFileRevision();
        if (fileObject instanceof LocalFileRevision) {
            IFileState state = ((LocalFileRevision)fileObject).getState();
            if (state != null) {
                return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_localRevision, (Object[])new Object[]{TextProcessor.process((String)element.getName()), element.getTimestamp()});
            }
        } else {
            if (Utils.isShowAuthor()) {
                return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_repository, (Object[])new String[]{element.getName(), element.getContentIdentifier(), element.getAuthor()});
            }
            return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_repositoryWithoutAuthor, (Object[])new Object[]{element.getName(), element.getContentIdentifier()});
        }
        return "";
    }

    public String getToolTipText() {
        Object[] titleObject = new Object[]{this.getLongName(this.left), this.getContentIdentifier(this.getLeftRevision()), this.getContentIdentifier(this.getRightRevision())};
        return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_compareResourceAndVersions, (Object[])titleObject);
    }

    public String getTitle() {
        Object[] titleObject = new Object[]{this.getShortName(this.left), this.getContentIdentifier(this.getLeftRevision()), this.getContentIdentifier(this.getRightRevision())};
        return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_compareResourceAndVersions, (Object[])titleObject);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFile.class || adapter == IResource.class) {
            if (this.getLocalElement() != null) {
                return (T)this.getLocalElement().getResource();
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    private String getShortName(ITypedElement element) {
        if (element instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement fileRevisionElement = (FileRevisionTypedElement)element;
            return fileRevisionElement.getName();
        }
        if (element instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement typedContent = (LocalResourceTypedElement)element;
            return typedContent.getResource().getName();
        }
        return element.getName();
    }

    private String getLongName(ITypedElement element) {
        if (element instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement fileRevisionElement = (FileRevisionTypedElement)element;
            return fileRevisionElement.getPath();
        }
        if (element instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement typedContent = (LocalResourceTypedElement)element;
            return typedContent.getResource().getFullPath().toString();
        }
        return element.getName();
    }

    private String getContentIdentifier(ITypedElement element) {
        if (element instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement fileRevisionElement = (FileRevisionTypedElement)element;
            IFileRevision fileObject = fileRevisionElement.getFileRevision();
            if (fileObject instanceof LocalFileRevision) {
                try {
                    IStorage storage = ((LocalFileRevision)fileObject).getStorage((IProgressMonitor)new NullProgressMonitor());
                    if (Adapters.adapt((Object)storage, IFileState.class) != null) {
                        return TeamUIMessages.CompareFileRevisionEditorInput_0;
                    }
                    if (Adapters.adapt((Object)storage, IFile.class) != null) {
                        return TeamUIMessages.CompareFileRevisionEditorInput_1;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                return fileRevisionElement.getContentIdentifier();
            }
        }
        return TeamUIMessages.CompareFileRevisionEditorInput_2;
    }

    @Override
    protected void fireInputChange() {
        ((MyDiffNode)this.getCompareResult()).fireChange();
    }

    @Override
    protected void contentsCreated() {
        super.contentsCreated();
        this.notifier.initialize();
    }

    @Override
    protected void handleDispose() {
        super.handleDispose();
        this.notifier.dispose();
        if (this.getLocalElement() != null) {
            this.getLocalElement().discardBuffer();
        }
    }

    public LocalResourceTypedElement getLocalElement() {
        if (this.left instanceof LocalResourceTypedElement) {
            return (LocalResourceTypedElement)this.left;
        }
        return null;
    }

    public ITypedElement getLeft() {
        return this.left;
    }

    public class MyDiffNode
    extends AbstractCompareInput {
        public MyDiffNode(ITypedElement left, ITypedElement right) {
            super(3, null, left, right);
        }

        @Override
        public void fireChange() {
            super.fireChange();
        }

        @Override
        protected CompareInputChangeNotifier getChangeNotifier() {
            return CompareFileRevisionEditorInput.this.notifier;
        }

        @Override
        public boolean needsUpdate() {
            return false;
        }

        @Override
        public void update() {
            this.fireChange();
        }
    }
}

