/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.io.InputStream;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileRevisionEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput {
    private final Object fileRevision;
    private final IStorage storage;

    public static FileRevisionEditorInput createEditorInputFor(IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        IStorage storage = revision.getStorage(monitor);
        return new FileRevisionEditorInput(revision, storage);
    }

    private static IStorage wrapStorage(final IStorage storage, final String charset) {
        if (charset == null) {
            return storage;
        }
        if (storage instanceof IFileState) {
            return new IFileState(){

                public <T> T getAdapter(Class<T> adapter) {
                    return (T)storage.getAdapter(adapter);
                }

                public boolean isReadOnly() {
                    return storage.isReadOnly();
                }

                public String getName() {
                    return storage.getName();
                }

                public IPath getFullPath() {
                    return storage.getFullPath();
                }

                public InputStream getContents() throws CoreException {
                    return storage.getContents();
                }

                public String getCharset() throws CoreException {
                    return charset;
                }

                public boolean exists() {
                    return ((IFileState)storage).exists();
                }

                public long getModificationTime() {
                    return ((IFileState)storage).getModificationTime();
                }
            };
        }
        return new IEncodedStorage(){

            public <T> T getAdapter(Class<T> adapter) {
                return (T)storage.getAdapter(adapter);
            }

            public boolean isReadOnly() {
                return storage.isReadOnly();
            }

            public String getName() {
                return storage.getName();
            }

            public IPath getFullPath() {
                return storage.getFullPath();
            }

            public InputStream getContents() throws CoreException {
                return storage.getContents();
            }

            public String getCharset() throws CoreException {
                return charset;
            }
        };
    }

    public FileRevisionEditorInput(Object revision, IStorage storage) {
        Assert.isNotNull((Object)revision);
        Assert.isNotNull((Object)storage);
        this.fileRevision = revision;
        this.storage = storage;
    }

    public FileRevisionEditorInput(IFileState state) {
        this(state, (IStorage)state);
    }

    public FileRevisionEditorInput(Object revision, IStorage storage, String charset) {
        this(revision, FileRevisionEditorInput.wrapStorage(storage, charset));
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        IFileRevision rev = this.getAdapter(IFileRevision.class);
        if (rev != null) {
            return NLS.bind((String)TeamUIMessages.nameAndRevision, (Object)rev.getName(), (Object)rev.getContentIdentifier());
        }
        IFileState state = this.getAdapter(IFileState.class);
        if (state != null) {
            return state.getName() + " " + DateFormat.getInstance().format(new Date(state.getModificationTime()));
        }
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.storage.getFullPath().toString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return (T)((Object)this);
        }
        if (adapter == IStorage.class) {
            return (T)this.storage;
        }
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return (T)object;
        }
        return (T)Adapters.adapt((Object)this.fileRevision, adapter);
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        IFileRevision rev = this.getAdapter(IFileRevision.class);
        if (rev != null) {
            return rev.getName();
        }
        return this.storage.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileRevisionEditorInput) {
            FileRevisionEditorInput other = (FileRevisionEditorInput)((Object)obj);
            return other.fileRevision.equals(this.fileRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.fileRevision.hashCode();
    }

    public IFileRevision getFileRevision() {
        if (this.fileRevision instanceof IFileRevision) {
            return (IFileRevision)this.fileRevision;
        }
        return null;
    }

    public URI getURI() {
        Object object = this.fileRevision;
        if (object instanceof IFileRevision) {
            IFileRevision fr = (IFileRevision)object;
            return fr.getURI();
        }
        return null;
    }
}

