/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.Messages;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;

public class ToolControlRenderer
extends SWTPartRenderer {
    private static final String HIDEABLE = "HIDEABLE";
    private static final String SHOW_RESTORE_MENU = "SHOW_RESTORE_MENU";
    private static final String LOCK_TOOLBAR_CMD_ID = "org.eclipse.ui.window.lockToolBar";
    public static final String STATE_ID = "org.eclipse.ui.commands.toggleState";
    @Inject
    private MApplication application;
    private Menu toolControlMenu;

    public Object createWidget(MUIElement element, Object parent) {
        IRendererFactory factory;
        AbstractPartRenderer renderer;
        if (!(element instanceof MToolControl) || !(parent instanceof ToolBar) && !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComp = (Composite)parent;
        MToolControl toolControl = (MToolControl)element;
        if (toolControl.getParent() instanceof MToolBar && (renderer = (factory = (IRendererFactory)this.context.get(IRendererFactory.class)).getRenderer((MUIElement)toolControl.getParent(), parent)) instanceof ToolBarManagerRenderer) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        IEclipseContext parentContext = this.getContextForParent(element);
        ToolItem sep = null;
        if (parent instanceof ToolBar) {
            sep = new ToolItem((ToolBar)parentWidget, 2);
        }
        IContributionFactory contributionFactory = (IContributionFactory)parentContext.get(IContributionFactory.class);
        IEclipseContext localContext = EclipseContextFactory.create();
        localContext.set(Composite.class.getName(), (Object)parentComp);
        localContext.set(MToolControl.class.getName(), (Object)toolControl);
        Object tcImpl = contributionFactory.create(toolControl.getContributionURI(), parentContext, localContext);
        toolControl.setObject(tcImpl);
        Control[] kids = parentComp.getChildren();
        if (kids.length == 0) {
            return null;
        }
        Control newCtrl = kids[kids.length - 1];
        if (sep != null && newCtrl != null) {
            sep.setControl(newCtrl);
            newCtrl.pack();
            sep.setWidth(newCtrl.getSize().x);
        }
        this.bindWidget((MUIElement)toolControl, newCtrl);
        boolean vertical = false;
        MElementContainer parentElement = element.getParent();
        if (parentElement instanceof MTrimBar) {
            MTrimBar bar = (MTrimBar)parentElement;
            vertical = bar.getSide() == SideValue.LEFT || bar.getSide() == SideValue.RIGHT;
        }
        CSSRenderingUtils cssUtils = (CSSRenderingUtils)parentContext.get(CSSRenderingUtils.class);
        MUIElement modelElement = (MUIElement)newCtrl.getData("modelElement");
        boolean draggable = modelElement != null && modelElement.getTags().contains("Draggable");
        newCtrl = cssUtils.frameMeIfPossible(newCtrl, null, vertical, draggable);
        boolean hideable = this.isHideable(toolControl);
        boolean showRestoreMenu = this.isRestoreMenuShowable(toolControl);
        if (showRestoreMenu || hideable) {
            this.createToolControlMenu(toolControl, newCtrl, hideable);
        }
        return newCtrl;
    }

    private boolean isRestoreMenuShowable(MToolControl toolControl) {
        return toolControl.getTags().contains(SHOW_RESTORE_MENU);
    }

    private boolean isHideable(MToolControl toolControl) {
        return toolControl.getTags().contains(HIDEABLE);
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MToolControl)) {
            return;
        }
        MToolControl mToolControl = (MToolControl)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"HIDDEN_EXPLICITLY")) {
                changedElement.setVisible(false);
            } else {
                Object obj;
                boolean hideable = UIEvents.contains((Event)event, (String)"NewValue", (Object)HIDEABLE);
                if ((UIEvents.contains((Event)event, (String)"NewValue", (Object)SHOW_RESTORE_MENU) || hideable) && (obj = changedElement.getWidget()) instanceof Control && ((Control)obj).getMenu() == null) {
                    this.createToolControlMenu((MToolControl)changedElement, (Control)obj, hideable);
                }
            }
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"HIDDEN_EXPLICITLY")) {
            changedElement.setVisible(true);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicAppStartup(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        List toolControls = this.modelService.findElements((MUIElement)this.application, null, MToolControl.class, null);
        for (MToolControl toolControl : toolControls) {
            if (!toolControl.getTags().contains("HIDDEN_EXPLICITLY")) continue;
            toolControl.setVisible(false);
        }
    }

    private void createToolControlMenu(MToolControl toolControl, Control renderedCtrl, boolean hideable) {
        this.toolControlMenu = new Menu(renderedCtrl);
        if (hideable) {
            MenuItem hideItem = new MenuItem(this.toolControlMenu, 0);
            hideItem.setText(Messages.ToolBarManagerRenderer_MenuCloseText);
            hideItem.addListener(13, event -> {
                boolean bl = toolControl.getTags().add("HIDDEN_EXPLICITLY");
            });
            new MenuItem(this.toolControlMenu, 2);
        }
        MenuItem restoreHiddenItems = new MenuItem(this.toolControlMenu, 0);
        restoreHiddenItems.setText(Messages.ToolBarManagerRenderer_MenuRestoreText);
        restoreHiddenItems.addListener(13, event -> this.removeHiddenTags(toolControl));
        MenuItem toggleLockToolbars = new MenuItem(this.toolControlMenu, 0);
        toggleLockToolbars.setText(this.getLockToolbarsText());
        toggleLockToolbars.addListener(13, event -> {
            EHandlerService handlerService = (EHandlerService)this.context.get(EHandlerService.class);
            ECommandService commandService = (ECommandService)this.context.get(ECommandService.class);
            ParameterizedCommand pCommand = commandService.createCommand(LOCK_TOOLBAR_CMD_ID, Collections.emptyMap());
            handlerService.executeHandler(pCommand);
            toggleLockToolbars.setText(this.getLockToolbarsText());
        });
        renderedCtrl.setMenu(this.toolControlMenu);
    }

    private String getLockToolbarsText() {
        ECommandService commandService = (ECommandService)this.context.get(ECommandService.class);
        Command command = commandService.getCommand(LOCK_TOOLBAR_CMD_ID);
        State state = command.getState(STATE_ID);
        if (state != null && state.getValue() instanceof Boolean) {
            boolean enabled = (Boolean)state.getValue();
            return enabled ? Messages.ToolBarManagerRenderer_UnlockToolbars : Messages.ToolBarManagerRenderer_LockToolbars;
        }
        return Messages.ToolBarManagerRenderer_ToggleLockToolbars;
    }

    private void removeHiddenTags(MToolControl toolControl) {
        MWindow mWindow = this.modelService.getTopLevelWindowFor((MUIElement)toolControl);
        List trimElements = this.modelService.findElements((MUIElement)mWindow, null, MTrimElement.class, null);
        for (MTrimElement trimElement : trimElements) {
            trimElement.getTags().remove("HIDDEN_EXPLICITLY");
        }
    }
}

