/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.util.Objects;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.pde.internal.build.Utils;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class ReachablePlugin
implements Comparable<Object> {
    public static final VersionRange WIDEST_RANGE = Utils.EMPTY_RANGE;
    public static final VersionRange NARROWEST_RANGE = new VersionRange('[', Version.emptyVersion, Version.emptyVersion, ')');
    private final String id;
    private final VersionRange range;
    private static final Version VERSION_MAX = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public ReachablePlugin(String id, VersionRange range) {
        this.id = id;
        this.range = range;
    }

    public ReachablePlugin(FeatureEntry entry) {
        this.id = entry.getId();
        this.range = Utils.createVersionRange(entry);
    }

    public String getId() {
        return this.id;
    }

    public VersionRange getRange() {
        return this.range;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof ReachablePlugin) {
            ReachablePlugin toCompare = (ReachablePlugin)o;
            int result = this.id.compareTo(toCompare.id);
            if (result != 0) {
                return result;
            }
            Version right = this.range.getRight() == null ? VERSION_MAX : this.range.getRight();
            Version toCompareRight = toCompare.range.getRight() == null ? VERSION_MAX : toCompare.range.getRight();
            result = this.substract(toCompareRight, toCompare.range.getLeft()).compareTo(this.substract(right, this.range.getLeft()));
            if (result != 0) {
                return result;
            }
            result = -Boolean.compare(this.range.getRightType() == ']', toCompare.range.getRightType() == ']');
            if (result != 0) {
                return result;
            }
            if (this.equals(o)) {
                return 0;
            }
            result = this.range.getLeft().compareTo(toCompareRight);
            if (result != 0) {
                return result;
            }
            return -1;
        }
        return -1;
    }

    private Version substract(Version v1, Version v2) {
        int major;
        int minor;
        int micro = 0;
        int carry = 0;
        if (v1.getMicro() < v2.getMicro()) {
            micro = Integer.MAX_VALUE - v2.getMicro() + v1.getMicro();
            carry = 1;
        } else {
            micro = v1.getMicro() - v2.getMicro();
            carry = 0;
        }
        if (v1.getMinor() < v2.getMinor() + carry) {
            minor = Integer.MAX_VALUE - (v2.getMinor() + carry) + v1.getMinor();
            carry = 1;
        } else {
            minor = v1.getMinor() - (v2.getMinor() + carry);
            carry = 0;
        }
        if (v1.getMajor() < v2.getMajor() + carry) {
            major = Integer.MAX_VALUE - (v2.getMajor() + carry) + v1.getMajor();
            carry = 1;
        } else {
            major = v1.getMajor() - (v2.getMajor() + carry);
            carry = 0;
        }
        return new Version(major, minor, micro);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReachablePlugin) {
            ReachablePlugin toCompare = (ReachablePlugin)obj;
            if (Objects.equals(this.id, toCompare.id) && this.range.getLeftType() == toCompare.range.getLeftType() && this.range.getRightType() == toCompare.range.getRightType() && Objects.equals(this.range.getLeft(), toCompare.range.getLeft()) && Objects.equals(this.range.getRight(), toCompare.range.getRight())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode() + this.range.hashCode() * 17;
    }

    public String toString() {
        return this.id + " " + this.range.toString();
    }
}

