/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;

public class LaunchConfigurationAction
extends Action {
    private final ILaunchConfiguration fConfig;
    private final String fMode;

    public LaunchConfigurationAction(ILaunchConfiguration config, String mode, String text, ImageDescriptor image, int accelerator) {
        super(MessageFormat.format(ActionMessages.LaunchConfigurationAction_0, Integer.toString(accelerator), text), image);
        this.fConfig = config;
        this.fMode = mode;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfig;
    }

    public void run() {
        this.runInternal(false);
    }

    public void runWithEvent(Event event) {
        block5: {
            if ((event.stateMask & SWT.MOD1) > 0) {
                try {
                    ILaunchGroup group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.fConfig.getType(), this.fMode);
                    if (group != null) {
                        DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)this.fConfig), group.getIdentifier());
                        break block5;
                    }
                    this.runInternal((event.stateMask & 0x20000) > 0);
                }
                catch (CoreException coreException) {}
            } else {
                this.runInternal((event.stateMask & 0x20000) > 0);
            }
        }
    }

    private void runInternal(boolean isShift) {
        DebugUITools.launch(this.fConfig, this.fMode, isShift);
    }
}

