/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.VarDefinitionsUsesVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractIncrementCleanUpCore
extends AbstractMultiFix {
    public ExtractIncrementCleanUpCore() {
        this(Collections.emptyMap());
    }

    public ExtractIncrementCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.extract_increment");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.extract_increment")) {
            return new String[]{MultiFixMessages.CodeStyleCleanUp_ExtractIncrement_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.extract_increment")) {
            return "i++;\nboolean isPositive = i > 0;\n";
        }
        return "boolean isPositive = ++i > 0;\n\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.extract_increment")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(Block visited) {
                ExpressionVisitor expressionVisitor = new ExpressionVisitor(visited, rewriteOperations);
                visited.accept((ASTVisitor)expressionVisitor);
                return expressionVisitor.result;
            }

            final class ExpressionVisitor
            extends ASTVisitor {
                private final Block startNode;
                private boolean result = true;
                private final /* synthetic */ List val$rewriteOperations;

                public ExpressionVisitor(Block startNode, List list) {
                    this.val$rewriteOperations = list;
                    this.startNode = startNode;
                }

                public boolean visit(Block visited) {
                    return this.startNode == visited;
                }

                public boolean visit(PrefixExpression visited) {
                    if (ASTNodes.hasOperator(visited, PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT)) {
                        return this.visitExpression((Expression)visited, visited.getOperand());
                    }
                    return true;
                }

                public boolean visit(PostfixExpression visited) {
                    if (ASTNodes.hasOperator(visited, PostfixExpression.Operator.INCREMENT, PostfixExpression.Operator.DECREMENT)) {
                        return this.visitExpression((Expression)visited, visited.getOperand());
                    }
                    return true;
                }

                public boolean visitExpression(Expression visited, Expression variable) {
                    SimpleName variableName = ASTNodes.as(variable, SimpleName.class);
                    if (this.result && !(visited.getParent() instanceof ExpressionStatement) && variableName != null && variableName.resolveBinding() != null && variableName.resolveBinding().getKind() == 3 && ASTNodes.isLocalVariable(variableName.resolveBinding())) {
                        return this.visitParent(visited, variable, (ASTNode)visited);
                    }
                    return true;
                }

                public boolean visitParent(Expression visited, Expression variable, ASTNode parent) {
                    ASTNode ancestor = parent.getParent();
                    if (ancestor != null) {
                        switch (ancestor.getNodeType()) {
                            case 25: {
                                IfStatement statement = (IfStatement)ancestor;
                                if (visited instanceof PrefixExpression && parent.getLocationInParent() == IfStatement.EXPRESSION_PROPERTY && !ASTNodes.isInElse(statement)) {
                                    return this.maybeExtractIncrement(visited, variable, (Statement)statement);
                                }
                                return true;
                            }
                            case 21: 
                            case 30: 
                            case 60: {
                                return this.maybeExtractIncrement(visited, variable, (Statement)ancestor);
                            }
                            case 41: 
                            case 53: {
                                if (visited instanceof PrefixExpression) {
                                    return this.maybeExtractIncrement(visited, variable, (Statement)ancestor);
                                }
                                return true;
                            }
                            case 17: 
                            case 46: {
                                if (visited instanceof PostfixExpression) {
                                    return this.maybeExtractIncrement(visited, variable, (Statement)ancestor);
                                }
                                return true;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 7: 
                            case 11: 
                            case 14: 
                            case 22: 
                            case 32: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 40: 
                            case 42: 
                            case 48: 
                            case 58: 
                            case 59: 
                            case 62: {
                                return this.visitParent(visited, variable, ancestor);
                            }
                            case 27: {
                                if (parent.getLocationInParent() == InfixExpression.LEFT_OPERAND_PROPERTY || ASTNodes.hasOperator((InfixExpression)ancestor, InfixExpression.Operator.AND, InfixExpression.Operator.DIVIDE, InfixExpression.Operator.EQUALS, InfixExpression.Operator.GREATER, InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.LEFT_SHIFT, InfixExpression.Operator.LESS, InfixExpression.Operator.LESS_EQUALS, InfixExpression.Operator.MINUS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.OR, InfixExpression.Operator.PLUS, InfixExpression.Operator.REMAINDER, InfixExpression.Operator.RIGHT_SHIFT_SIGNED, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, InfixExpression.Operator.TIMES, InfixExpression.Operator.XOR)) {
                                    return this.visitParent(visited, variable, ancestor);
                                }
                                return true;
                            }
                            case 16: {
                                if (parent.getLocationInParent() == ConditionalExpression.EXPRESSION_PROPERTY) {
                                    return this.visitParent(visited, variable, ancestor);
                                }
                                return true;
                            }
                        }
                    }
                    return true;
                }

                private boolean maybeExtractIncrement(Expression visited, Expression variable, Statement statement) {
                    VarDefinitionsUsesVisitor varDefinitionsUsesVisitor;
                    SimpleName variableName = ASTNodes.as(variable, SimpleName.class);
                    try {
                        varDefinitionsUsesVisitor = new VarDefinitionsUsesVisitor((IVariableBinding)variableName.resolveBinding(), (ASTNode)statement, true);
                    }
                    catch (Exception e) {
                        return true;
                    }
                    if (varDefinitionsUsesVisitor.getWrites().isEmpty() && varDefinitionsUsesVisitor.getReads().size() == 1 && (visited instanceof PrefixExpression || !ASTNodes.fallsThrough(statement))) {
                        this.val$rewriteOperations.add(new ExtractIncrementOperation(visited, variable, statement));
                        this.result = false;
                        return false;
                    }
                    return true;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.CodeStyleCleanUp_ExtractIncrement_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class ExtractIncrementOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final Expression visited;
        private final Expression variable;
        private final Statement statement;

        public ExtractIncrementOperation(Expression visited, Expression variable, Statement statement) {
            this.visited = visited;
            this.variable = variable;
            this.statement = statement;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.CodeStyleCleanUp_ExtractIncrement_description, cuRewrite);
            ASTNodes.replaceButKeepComment(rewrite, ASTNodes.getHighestCompatibleNode((ASTNode)this.visited, ParenthesizedExpression.class), rewrite.createCopyTarget((ASTNode)this.variable), group);
            if (this.visited instanceof PostfixExpression) {
                ExpressionStatement newAssignment = ast.newExpressionStatement(ASTNodes.createMoveTarget(rewrite, this.visited));
                if (ASTNodes.canHaveSiblings(this.statement)) {
                    ListRewrite listRewrite = rewrite.getListRewrite(this.statement.getParent(), (ChildListPropertyDescriptor)this.statement.getLocationInParent());
                    listRewrite.insertAfter((ASTNode)newAssignment, (ASTNode)this.statement, group);
                } else {
                    Block newBlock = ast.newBlock();
                    newBlock.statements().add(ASTNodes.createMoveTarget(rewrite, this.statement));
                    newBlock.statements().add(newAssignment);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.statement, (ASTNode)newBlock, group);
                }
            } else {
                PostfixExpression newPostfixExpression = ast.newPostfixExpression();
                newPostfixExpression.setOperand(ASTNodes.createMoveTarget(rewrite, this.variable));
                if (ASTNodes.hasOperator((PrefixExpression)this.visited, PrefixExpression.Operator.INCREMENT, new PrefixExpression.Operator[0])) {
                    newPostfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
                } else {
                    newPostfixExpression.setOperator(PostfixExpression.Operator.DECREMENT);
                }
                ExpressionStatement newAssignment = ast.newExpressionStatement((Expression)newPostfixExpression);
                if (ASTNodes.canHaveSiblings(this.statement)) {
                    ListRewrite listRewrite = rewrite.getListRewrite(this.statement.getParent(), (ChildListPropertyDescriptor)this.statement.getLocationInParent());
                    listRewrite.insertBefore((ASTNode)newAssignment, (ASTNode)this.statement, group);
                } else {
                    Block newBlock = ast.newBlock();
                    newBlock.statements().add(newAssignment);
                    newBlock.statements().add(ASTNodes.createMoveTarget(rewrite, this.statement));
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.statement, (ASTNode)newBlock, group);
                }
            }
        }
    }
}

