/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.SuppressWarningsFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class SuppressWarningsCleanUp
extends AbstractMultiFix {
    private String fWarningToken;
    private CompilationUnit fSavedCompilationUnit = null;

    public SuppressWarningsCleanUp(Map<String, String> options) {
        super(options);
    }

    public SuppressWarningsCleanUp() {
    }

    public void setWarningToken(String warningToken) {
        this.fWarningToken = warningToken;
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        return this.isEnabled("cleanup.add_necessary_suppress_warnings");
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        IProposableFix coreFix = SuppressWarningsFixCore.createAllFix(this.fSavedCompilationUnit == null ? compilationUnit : this.fSavedCompilationUnit, this.fWarningToken);
        return coreFix;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        IProposableFix coreFix = SuppressWarningsFixCore.createAllFix(compilationUnit, problems, this.fWarningToken);
        return coreFix;
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_necessary_suppress_warnings")) {
            result.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        return new String[0];
    }

    @Override
    public String getPreview() {
        return "";
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (this.fWarningToken != null && this.fWarningToken.equals(CorrectionEngine.getWarningToken((int)problem.getProblemId()))) {
            return this.isEnabled("cleanup.add_necessary_suppress_warnings");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        try {
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            if (!cu.isStructureKnown()) {
                return 0;
            }
        }
        catch (JavaModelException e) {
            return 0;
        }
        this.fSavedCompilationUnit = compilationUnit;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.add_necessary_suppress_warnings")) {
            result += this.getNumberOfProblems(problems, compilationUnit);
        }
        return result;
    }

    private int getNumberOfProblems(IProblem[] problems, CompilationUnit compilationUnit) {
        int result = 0;
        if (this.fWarningToken == null) {
            return 1;
        }
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            ProblemLocation location = new ProblemLocation(problem);
            if (this.fWarningToken.equals(CorrectionEngine.getWarningToken((int)location.getProblemId()))) {
                ++result;
            }
            ++n2;
        }
        return result;
    }
}

