/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractVersionFinishOperation;

public abstract class AbstractHotfixOperation
extends AbstractVersionFinishOperation {
    public AbstractHotfixOperation(GitFlowRepository repository, String hotfixName) {
        super(repository, hotfixName);
    }

    protected static String getHotfixName(GitFlowRepository repository) throws WrongGitFlowStateException, CoreException, IOException {
        String currentBranch = repository.getRepository().getBranch();
        if (currentBranch == null || !repository.isHotfix()) {
            throw new WrongGitFlowStateException(CoreText.AbstractHotfixOperation_notOnAHotfixBranch);
        }
        return currentBranch.substring(repository.getConfig().getHotfixPrefix().length());
    }
}

