/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.start;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.prefs.BackingStoreException;

@Component
public class PreferencesMigrator
extends Job {
    public PreferencesMigrator() {
        super("Git preferences migration");
        this.setSystem(true);
        this.setUser(false);
    }

    @Reference
    void setPreferencesService(IPreferencesService service) {
    }

    @Reference
    void setWorkspace(IWorkspace workspace) {
    }

    @Activate
    void start() {
        this.schedule();
    }

    @Deactivate
    void shutDown() {
        this.cancel();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.migrate();
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void migrate() {
        IEclipsePreferences corePrefs = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
        boolean changed = false;
        IEclipsePreferences uiPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.egit.ui");
        String old_ui_preference_key = "remote_connection_timeout";
        int timeout = corePrefs.getInt("core_remote_connection_timeout", -1);
        if (timeout < 0 && (timeout = uiPrefs.getInt(old_ui_preference_key, -1)) > 0) {
            corePrefs.putInt("core_remote_connection_timeout", timeout);
            uiPrefs.remove(old_ui_preference_key);
            changed = true;
        }
        if (changed) {
            try {
                corePrefs.flush();
                uiPrefs.flush();
            }
            catch (BackingStoreException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
    }
}

