/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ExcludeExceptionLocationAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        for (IJavaThread thread : selection) {
            try {
                IBreakpoint[] breakpoints = thread.getBreakpoints();
                IJavaStackFrame frame = (IJavaStackFrame)thread.getTopStackFrame();
                String newFilter = frame.getDeclaringTypeName();
                int index = newFilter.indexOf(60);
                if (index > 0) {
                    newFilter = newFilter.substring(0, index);
                }
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (breakpoint instanceof IJavaExceptionBreakpoint) {
                        IJavaExceptionBreakpoint exBreakpoint = (IJavaExceptionBreakpoint)breakpoint;
                        String[] current = exBreakpoint.getExclusionFilters();
                        String[] newFilters = new String[current.length + 1];
                        System.arraycopy(current, 0, newFilters, 0, current.length);
                        newFilters[current.length] = newFilter;
                        exBreakpoint.setExclusionFilters(newFilters);
                        action.setEnabled(false);
                    }
                    ++i;
                }
            }
            catch (CoreException de) {
                JDIDebugUIPlugin.log(de);
            }
        }
    }
}

