/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.ui.DebugPopup;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.DisplayAction;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.display.DisplayView;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PopupDisplayAction
extends DisplayAction {
    public static final String ACTION_DEFINITION_ID = "org.eclipse.jdt.debug.ui.commands.Display";
    private String snippet;
    private String resultString;
    private ITextEditor fTextEditor;
    private ISelection fSelectionBeforeEvaluation;

    private void showPopup(StyledText textWidget) {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof ITextEditor) {
            this.fTextEditor = (ITextEditor)part;
            this.fSelectionBeforeEvaluation = this.getTargetSelection();
        }
        DisplayPopup displayPopup = new DisplayPopup(this.getShell(), textWidget);
        displayPopup.open();
    }

    @Override
    protected void displayStringResult(String currentSnippet, String currentResultString) {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof DisplayView) {
            super.displayStringResult(currentSnippet, currentResultString);
            return;
        }
        final StyledText textWidget = EvaluateAction.getStyledText(part);
        if (textWidget == null) {
            super.displayStringResult(currentSnippet, currentResultString);
        } else {
            this.snippet = currentSnippet;
            this.resultString = currentResultString;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PopupDisplayAction.this.showPopup(textWidget);
                }
            });
            this.evaluationCleanup();
        }
    }

    private class DisplayPopup
    extends DebugPopup {
        public DisplayPopup(Shell shell, StyledText textWidget) {
            super(shell, PopupDisplayAction.getPopupAnchor(textWidget), PopupDisplayAction.ACTION_DEFINITION_ID);
        }

        protected String getActionText() {
            return ActionMessages.PopupDisplayAction_2;
        }

        protected void persist() {
            IDataDisplay dataDisplay;
            IDataDisplay directDisplay = PopupDisplayAction.this.getDirectDataDisplay();
            Display display = JDIDebugUIPlugin.getStandardDisplay();
            if (!display.isDisposed() && (dataDisplay = PopupDisplayAction.this.getDataDisplay()) != null) {
                if (directDisplay == null) {
                    dataDisplay.displayExpression(PopupDisplayAction.this.snippet);
                }
                dataDisplay.displayExpressionValue(PopupDisplayAction.this.resultString);
            }
        }

        protected Control createDialogArea(Composite parent) {
            GridData gd = new GridData(1808);
            StyledText text = new StyledText(parent, 842);
            text.setLayoutData((Object)gd);
            text.setForeground(parent.getDisplay().getSystemColor(28));
            text.setBackground(parent.getDisplay().getSystemColor(29));
            text.setText(PopupDisplayAction.this.resultString);
            return text;
        }

        public boolean close() {
            boolean returnValue = super.close();
            if (PopupDisplayAction.this.fTextEditor != null && PopupDisplayAction.this.fSelectionBeforeEvaluation != null) {
                PopupDisplayAction.this.fTextEditor.getSelectionProvider().setSelection(PopupDisplayAction.this.fSelectionBeforeEvaluation);
                PopupDisplayAction.this.fTextEditor = null;
                PopupDisplayAction.this.fSelectionBeforeEvaluation = null;
            }
            return returnValue;
        }
    }
}

