/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.tasks.ui.wizards;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.QueryPageFilter;

public class QueryPageSearch {
    private final Map<String, QueryPageFilter> filterByFieldName = new LinkedHashMap<String, QueryPageFilter>();

    public QueryPageSearch() {
    }

    public QueryPageSearch(String queryParameter) {
        this.fromUrl(queryParameter);
    }

    public void addFilter(String key, String value) {
        QueryPageFilter filter = this.filterByFieldName.get(key);
        if (filter == null) {
            filter = new QueryPageFilter(key, value);
            this.filterByFieldName.put(key, filter);
        }
    }

    public void addFilter(QueryPageFilter filter) {
        this.filterByFieldName.put(filter.getKey(), filter);
    }

    public List<QueryPageFilter> getFilters() {
        return new ArrayList<QueryPageFilter>(this.filterByFieldName.values());
    }

    public QueryPageFilter getFilter(String key) {
        return this.filterByFieldName.get(key);
    }

    public void fromUrl(String url) {
        int idx = url.indexOf(63);
        StringTokenizer t = new StringTokenizer(idx != -1 ? url.substring(idx + 1) : url, "&");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            int i = token.indexOf("=");
            if (i == -1) continue;
            try {
                String key = URLDecoder.decode(token.substring(0, i), "UTF-8");
                String value = URLDecoder.decode(token.substring(i + 1), "UTF-8");
                QueryPageFilter filter = this.filterByFieldName.get(key);
                if (filter == null) {
                    this.addFilter(key, value);
                    continue;
                }
                filter.addValue(value);
            }
            catch (UnsupportedEncodingException e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Unexpected exception while decoding URL", (Throwable)e));
            }
        }
    }

    public String toQuery() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (QueryPageFilter filter : this.filterByFieldName.values()) {
            for (String actualValue : filter.getValues()) {
                String encodedValue = null;
                try {
                    encodedValue = URLEncoder.encode(actualValue, "UTF-8");
                    if (count++ > 0) {
                        sb.append("&");
                    }
                    sb.append(filter.getKey());
                    sb.append("=");
                    sb.append(encodedValue);
                }
                catch (UnsupportedEncodingException e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Unexpected exception while encoding URL", (Throwable)e));
                }
            }
        }
        return sb.toString();
    }
}

