/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import java.util.ArrayList;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.references.XMLReferencesPlugin;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchNode;
import org.eclipse.lemminx.extensions.references.search.SearchQuery;
import org.eclipse.lemminx.extensions.references.search.SearchQueryFactory;
import org.eclipse.lemminx.services.extensions.rename.IPrepareRenameRequest;
import org.eclipse.lemminx.services.extensions.rename.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.rename.IRenameRequest;
import org.eclipse.lemminx.services.extensions.rename.IRenameResponse;
import org.eclipse.lemminx.utils.TextEditUtils;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class XMLReferencesRenameParticipant
implements IRenameParticipant {
    private final XMLReferencesPlugin plugin;

    public XMLReferencesRenameParticipant(XMLReferencesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Either<Range, PrepareRenameResult> prepareRename(IPrepareRenameRequest request, CancelChecker cancelChecker) {
        SearchQuery query = SearchQueryFactory.createQuery(request.getNode(), request.getOffset(), this.plugin.getReferencesSettings());
        if (query == null) {
            return null;
        }
        SearchNode searchNode = query.getSearchNode();
        if (searchNode == null) {
            return null;
        }
        DOMNode node = searchNode.getNode();
        if (node == null || node.isOwnerDocument()) {
            return null;
        }
        if (!searchNode.isValid()) {
            return null;
        }
        Range range = searchNode.createRange(true);
        String placeholder = XMLReferencesRenameParticipant.createPlaceHolder(searchNode);
        return Either.forRight(new PrepareRenameResult(range, placeholder));
    }

    private static String createPlaceHolder(SearchNode searchNode) {
        String placeholder = searchNode.getValue(null);
        if (searchNode.isNeedToAjdustWithPrefix()) {
            String prefix = searchNode.getPrefix();
            return placeholder.substring(prefix.length(), placeholder.length());
        }
        return placeholder;
    }

    @Override
    public void doRename(IRenameRequest request, IRenameResponse renameResponse, CancelChecker cancelChecker) {
        renameResponse.addTextDocumentEdit(this.getRenameTextDocumentEdit(request, cancelChecker));
    }

    private TextDocumentEdit getRenameTextDocumentEdit(IRenameRequest request, CancelChecker cancelChecker) {
        SearchQuery query = SearchQueryFactory.createToQueryByRetrievingToBefore(request.getNode(), request.getOffset(), this.plugin.getReferencesSettings(), cancelChecker);
        if (query == null) {
            return null;
        }
        query.setMatchNode(true);
        query.setSearchInIncludedFiles(true);
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        String newText = request.getNewText();
        SearchEngine.getInstance().search(query, (fromSearchNode, toSearchNode, expression) -> {
            Range range = fromSearchNode.createRange(true);
            TextEdit textEdit = new TextEdit(range, newText);
            textEdits.add(textEdit);
        }, cancelChecker);
        Range range = query.getSearchNode().createRange(true);
        textEdits.add(0, new TextEdit(range, newText));
        return TextEditUtils.creatTextDocumentEdit(request.getXMLDocument(), textEdits);
    }
}

