/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lemminx.services.extensions.rename.IRenameResponse;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

class RenameResponse
implements IRenameResponse {
    private List<Either<TextDocumentEdit, ResourceOperation>> documentChanges = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>();

    RenameResponse() {
    }

    @Override
    public void addTextDocumentEdit(TextDocumentEdit textDocumentEdit) {
        if (textDocumentEdit == null) {
            return;
        }
        String documentURI = textDocumentEdit.getTextDocument().getUri();
        Optional<TextDocumentEdit> change = this.documentChanges.stream().filter(Either::isLeft).filter(e -> documentURI.equals(((TextDocumentEdit)e.getLeft()).getTextDocument().getUri())).map(Either::getLeft).findFirst();
        if (change.isPresent()) {
            TextDocumentEdit existingTextDocumentEdit = change.get();
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            edits.addAll(existingTextDocumentEdit.getEdits());
            textDocumentEdit.getEdits().stream().forEach(te -> {
                if (!edits.contains(te)) {
                    edits.add((TextEdit)te);
                }
            });
            existingTextDocumentEdit.setEdits(edits);
        } else {
            this.documentChanges.add(Either.forLeft(textDocumentEdit));
        }
    }

    @Override
    public void addResourceOperation(ResourceOperation resourceOperation) {
        this.documentChanges.add(Either.forRight(resourceOperation));
    }

    public List<Either<TextDocumentEdit, ResourceOperation>> getDocumentChanges() {
        return this.documentChanges;
    }
}

