/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.IMavenToolbox;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.AbstractRunnable;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.internal.project.LifecycleMappingConfiguration;
import org.eclipse.m2e.core.internal.project.MavenProjectImportResult;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.IProjectCreationListener;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IProjectConfigurationManager.class, IMavenProjectChangedListener.class, IResourceChangeListener.class}, property={"event.mask:Integer=4"})
public class ProjectConfigurationManager
implements IProjectConfigurationManager,
IMavenProjectChangedListener,
IResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectConfigurationManager.class);
    @Reference
    ProjectRegistryManager projectManager;
    @Reference
    MavenModelManager mavenModelManager;
    @Reference
    IMavenMarkerManager mavenMarkerManager;
    @Reference
    IMaven maven;
    @Reference
    IMavenConfiguration mavenConfiguration;
    @Reference
    PlexusContainerManager containerManager;
    private static final String GROUP_ID = "[groupId]";
    private static final String ARTIFACT_ID = "[artifactId]";
    private static final String VERSION = "[version]";
    private static final String NAME = "[name]";

    @Override
    public List<IMavenProjectImportResult> importProjects(Collection<MavenProjectInfo> projectInfos, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        return this.importProjects(projectInfos, configuration, null, monitor);
    }

    @Override
    public List<IMavenProjectImportResult> importProjects(Collection<MavenProjectInfo> projectInfos, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        return IMavenExecutionContext.getThreadContext().orElseGet(this.maven::createExecutionContext).execute((context, m) -> {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (String)Messages.ProjectConfigurationManager_task_importing, (int)100);
            long t1 = System.currentTimeMillis();
            ArrayList<MavenProjectImportResult> result = new ArrayList<MavenProjectImportResult>();
            int total = projectInfos.size();
            ArrayList<IProject> projects = new ArrayList<IProject>(total);
            int i = 0;
            List<IProject> existingProjects = this.findExistingProjectsToHideFrom();
            SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.split(10), (int)projectInfos.size());
            for (MavenProjectInfo projectInfo : projectInfos) {
                long t11 = System.currentTimeMillis();
                IProject project = this.create(projectInfo, configuration, listener, (IProgressMonitor)subProgress.split(1));
                result.add(new MavenProjectImportResult(projectInfo, project));
                if (project == null) continue;
                projects.add(project);
                long importTime = System.currentTimeMillis() - t11;
                log.debug("Imported project {} ({}/{}) in {} ms", new Object[]{project.getName(), ++i, total, importTime});
            }
            this.hideNestedProjectsFromParents(projects, existingProjects, m);
            this.configureNewMavenProjects(projects, (IProgressMonitor)progress.split(90));
            long t2 = System.currentTimeMillis();
            log.info("Imported and configured {} project(s) in {} sec", (Object)total, (Object)((t2 - t1) / 1000L));
            return result;
        }, monitor);
    }

    private void setHidden(IResource resource) {
        try {
            resource.setHidden(true);
        }
        catch (Exception ex) {
            log.error("Failed to hide resource: " + (resource.getLocation() == null ? resource.getName() : resource.getLocation().toOSString()), (Throwable)ex);
        }
    }

    void hideNestedProjectsFromParents(List<IProject> projects, List<IProject> existingProjects, IProgressMonitor monitor) {
        if (!MavenPlugin.getMavenConfiguration().isHideFoldersOfNestedProjects()) {
            return;
        }
        HashMap<File, IProject> projectFileMap = new HashMap<File, IProject>();
        if (existingProjects != null) {
            for (IProject project : existingProjects) {
                if (project.getLocation() == null) continue;
                projectFileMap.put(project.getLocation().toFile(), project);
            }
        }
        for (IProject project : projects) {
            if (project.getLocation() == null) continue;
            projectFileMap.put(project.getLocation().toFile(), project);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        HashSet<IProject> refreshedProjects = new HashSet<IProject>();
        for (IProject project : projects) {
            IFolder folder;
            File projectFile;
            IProject physicalParentProject;
            block13: {
                if (monitor.isCanceled()) {
                    return;
                }
                if (project.getLocation() == null || (physicalParentProject = (IProject)projectFileMap.get((projectFile = project.getLocation().toFile()).getParentFile())) == null) continue;
                if (!refreshedProjects.contains(physicalParentProject)) {
                    try {
                        try {
                            physicalParentProject.refreshLocal(1, monitor);
                        }
                        catch (Exception e) {
                            log.error("Failed to refresh " + physicalParentProject.getName(), (Throwable)e);
                            refreshedProjects.add(physicalParentProject);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        refreshedProjects.add(physicalParentProject);
                        throw throwable;
                    }
                    refreshedProjects.add(physicalParentProject);
                }
            }
            if (!(folder = physicalParentProject.getFolder(projectFile.getName())).exists()) continue;
            this.setHidden((IResource)folder);
        }
    }

    private void configureNewMavenProjects(List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectConfigurationManager_task_configuring, (int)100);
        LinkedHashSet<IFile> pomFiles = new LinkedHashSet<IFile>();
        for (IProject project : projects) {
            File baseDir = project.getLocation().toFile();
            IMavenToolbox.of(this.containerManager.getComponentLookup(baseDir)).locatePom(baseDir).ifPresent(pomFile -> pomFiles.add(project.getFile(pomFile.getName())));
        }
        progress.subTask(Messages.ProjectConfigurationManager_task_refreshing);
        this.projectManager.refresh(pomFiles, (IProgressMonitor)progress.split(75));
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.split(5), (int)projects.size());
        ArrayList<IMavenProjectFacade> facades = new ArrayList<IMavenProjectFacade>(projects.size());
        for (IProject project : projects) {
            MavenProjectFacade facade = this.projectManager.create(project, (IProgressMonitor)subProgress.split(1));
            if (facade == null) continue;
            facades.add(facade);
        }
        this.sortProjects(facades, (IProgressMonitor)progress.split(5));
        subProgress = SubMonitor.convert((IProgressMonitor)progress.split(15), (int)(facades.size() * 10));
        for (IMavenProjectFacade facade : facades) {
            progress.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_updating, (Object)facade.getProject().getName()));
            MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)subProgress.split(1));
            ProjectConfigurationRequest request = new ProjectConfigurationRequest(facade, mavenProject);
            this.updateProjectConfiguration(request, (IProgressMonitor)subProgress.split(9));
        }
    }

    public void sortProjects(List<IMavenProjectFacade> facades, IProgressMonitor monitor) throws CoreException {
        HashMap<MavenProject, IMavenProjectFacade> mavenProjectToFacadeMap = new HashMap<MavenProject, IMavenProjectFacade>(facades.size());
        for (IMavenProjectFacade facade : facades) {
            mavenProjectToFacadeMap.put(facade.getMavenProject(monitor), facade);
        }
        facades.clear();
        for (MavenProject mavenProject : this.maven.getSortedProjects(new ArrayList<MavenProject>(mavenProjectToFacadeMap.keySet()))) {
            facades.add((IMavenProjectFacade)mavenProjectToFacadeMap.get(mavenProject));
        }
    }

    @Override
    public void updateProjectConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        this.updateProjectConfiguration(new MavenUpdateRequest(project, this.mavenConfiguration.isOffline(), false), monitor);
    }

    @Override
    public void updateProjectConfiguration(MavenUpdateRequest request, IProgressMonitor monitor) throws CoreException {
        if (request.getPomFiles().size() != 1) {
            throw new IllegalArgumentException();
        }
        Map<String, IStatus> updateStatus = this.updateProjectConfiguration(request, true, true, monitor);
        IStatus status = updateStatus.values().iterator().next();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public Map<String, IStatus> updateProjectConfiguration(MavenUpdateRequest request, boolean updateConfiguration, boolean cleanProjects, IProgressMonitor monitor) {
        return this.updateProjectConfiguration(request, updateConfiguration, cleanProjects, false, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public Map<String, IStatus> updateProjectConfiguration(MavenUpdateRequest request, boolean updateConfiguration, boolean cleanProjects, boolean refreshFromLocal, IProgressMonitor monitor) {
        try {
            return MavenImpl.execute(this.maven, request.isOffline(), request.isForceDependencyUpdate(), (ICallable<Map>)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/m2e/core/embedder/IMavenExecutionContext;Lorg/eclipse/core/runtime/IProgressMonitor;)Ljava/lang/Object;, lambda$3(org.eclipse.m2e.core.project.MavenUpdateRequest boolean boolean boolean org.eclipse.m2e.core.embedder.IMavenExecutionContext org.eclipse.core.runtime.IProgressMonitor ), (Lorg/eclipse/m2e/core/embedder/IMavenExecutionContext;Lorg/eclipse/core/runtime/IProgressMonitor;)Ljava/util/Map;)((ProjectConfigurationManager)this, (MavenUpdateRequest)request, (boolean)updateConfiguration, (boolean)cleanProjects, (boolean)refreshFromLocal), monitor);
        }
        catch (CoreException ex) {
            result = new LinkedHashMap<String, IStatus>();
            ** for (pomFile : request.getPomFiles())
        }
lbl-1000:
        // 1 sources

        {
            result.put(pomFile.getProject().getName(), ex.getStatus());
            continue;
        }
lbl9:
        // 1 sources

        return result;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, IStatus> updateProjectConfiguration0(Collection<IFile> pomFiles, boolean updateConfiguration, boolean cleanProjects, boolean refreshFromLocal, IProgressMonitor m) {
        block13: {
            monitor = SubMonitor.convert((IProgressMonitor)m, (String)Messages.ProjectConfigurationManager_task_updating_projects, (int)(pomFiles.size() * (1 + (updateConfiguration != false ? 1 : 0) + (cleanProjects != false ? 1 : 0) + (refreshFromLocal != false ? 1 : 0))));
            start = System.currentTimeMillis();
            ProjectConfigurationManager.log.info("Update started");
            projects = new LinkedHashMap<IFile, IMavenProjectFacade>();
            updateStatus = new HashMap<String, IStatus>();
            pomsToRefresh = new ArrayList<IFile>();
            if (refreshFromLocal) {
                for (IFile pom : pomFiles) {
                    project = pom.getProject();
                    try {
                        project.refreshLocal(2, (IProgressMonitor)monitor.split(1, 1));
                        pomsToRefresh.add(pom);
                    }
                    catch (CoreException ex) {
                        updateStatus.put(project.getName(), ex.getStatus());
                    }
                }
            } else {
                pomsToRefresh.addAll(pomFiles);
            }
            refreshLocal = System.currentTimeMillis();
            try {
                refresh = this.projectManager.refresh(pomsToRefresh, (IProgressMonitor)monitor.split(pomFiles.size()));
                for (IFile pom : pomsToRefresh) {
                    project = pom.getProject();
                    status = refresh.get(pom);
                    if (status != null && !status.isOK()) {
                        updateStatus.put(project.getName(), status);
                        continue;
                    }
                    facade = this.projectManager.getProject(project);
                    if (facade != null) {
                        projects.put(pom, facade);
                    }
                    updateStatus.put(project.getName(), Status.OK_STATUS);
                }
                break block13;
            }
            catch (CoreException ex) {
                ** for (pom : pomsToRefresh)
            }
lbl-1000:
            // 1 sources

            {
                project = pom.getProject();
                updateStatus.put(project.getName(), ex.getStatus());
                continue;
            }
        }
        refreshProjects = System.currentTimeMillis();
        if (updateConfiguration) {
            projects.values().removeIf((Predicate<IMavenProjectFacade>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$4(java.util.Map org.eclipse.core.runtime.SubMonitor org.eclipse.m2e.core.project.IMavenProjectFacade ), (Lorg/eclipse/m2e/core/project/IMavenProjectFacade;)Z)((ProjectConfigurationManager)this, updateStatus, (SubMonitor)monitor));
        }
        updateConfig = System.currentTimeMillis();
        if (cleanProjects) {
            projects.values().removeIf((Predicate<IMavenProjectFacade>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$5(org.eclipse.core.runtime.SubMonitor java.util.Map org.eclipse.m2e.core.project.IMavenProjectFacade ), (Lorg/eclipse/m2e/core/project/IMavenProjectFacade;)Z)((SubMonitor)monitor, updateStatus));
        }
        clean = System.currentTimeMillis();
        ProjectConfigurationManager.log.info("Update completed for {} poms: {}, {}, {} ", new Object[]{pomFiles.size(), this.printDelta("local refresh", start, refreshLocal), this.printDelta("refresh facades", refreshLocal, refreshProjects), this.printDelta("update config", refreshProjects, updateConfig), this.printDelta("clean projects config", updateConfig, clean), this.printDelta("total", start, clean)});
        return updateStatus;
    }

    private String printDelta(String type, long start, long end) {
        double delay = (end - start) / 1000L;
        return String.format("%s takes %.2f sec", type, delay);
    }

    private void updateProjectConfiguration(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.mavenProjectFacade().getProject();
        long start = System.currentTimeMillis();
        IMavenProjectFacade mavenProjectFacade = request.mavenProjectFacade();
        log.debug("Updating project configuration for {}.", (Object)mavenProjectFacade);
        this.addMavenNature(project, monitor);
        MavenProject mavenProject = request.mavenProject();
        Properties mavenProperties = mavenProject.getProperties();
        String sourceEncoding = mavenProperties.getProperty("project.build.sourceEncoding");
        if (!Objects.equals(project.getDefaultCharset(false), sourceEncoding)) {
            log.debug("Setting encoding for project {}: {}", (Object)project.getName(), (Object)sourceEncoding);
            project.setDefaultCharset(sourceEncoding, monitor);
        }
        IMavenExecutionContext executionContext = this.projectManager.createExecutionContext(mavenProjectFacade.getPom(), mavenProjectFacade.getConfiguration());
        executionContext.execute(mavenProject, (context, m) -> {
            ILifecycleMapping lifecycleMapping = this.getLifecycleMapping(mavenProjectFacade);
            if (lifecycleMapping != null) {
                this.mavenMarkerManager.deleteMarkers((IResource)mavenProjectFacade.getProject(), "org.eclipse.m2e.core.maven2Problem.configuration");
                lifecycleMapping.configure(request, m);
                LifecycleMappingConfiguration.persist(request.mavenProjectFacade(), m);
            } else {
                log.debug("LifecycleMapping is null for project {}", (Object)mavenProjectFacade);
            }
            return null;
        }, monitor);
        log.debug("Updated project configuration for {} in {} ms.", (Object)mavenProjectFacade, (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void enableMavenNature(final IProject project, final IProjectConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.ProjectConfigurationManager_task_enable_nature);
        IMavenExecutionContext.getThreadContext().orElseGet(this.maven::createExecutionContext).execute(new AbstractRunnable(){

            @Override
            protected void run(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                ProjectConfigurationManager.this.enableBasicMavenNature(project, configuration, monitor);
                ProjectConfigurationManager.this.configureNewMavenProjects(Collections.singletonList(project), monitor);
            }
        }, monitor);
    }

    void enableBasicMavenNature(IProject project, IProjectConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ResolverConfigurationIO.saveResolverConfiguration(project, configuration);
        this.addMavenNature(project, monitor);
    }

    private void addMavenNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = "org.eclipse.m2e.core.maven2Nature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    @Override
    public void disableMavenNature(IProject project, IProgressMonitor monitor) throws CoreException {
        ILifecycleMapping lifecycleMapping;
        monitor.subTask(Messages.ProjectConfigurationManager_task_disable_nature);
        MavenProjectFacade facade = this.projectManager.create(project, monitor);
        if (facade != null && (lifecycleMapping = this.getLifecycleMapping(facade)) != null) {
            ProjectConfigurationRequest request = new ProjectConfigurationRequest(facade, facade.getMavenProject(monitor));
            lifecycleMapping.unconfigure(request, monitor);
        }
        project.deleteMarkers("org.eclipse.m2e.core.maven2Problem", true, 2);
        IProjectDescription description = project.getDescription();
        ArrayList<String> newNatures = new ArrayList<String>();
        String[] stringArray = description.getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            if (!"org.eclipse.m2e.core.maven2Nature".equals(natureId)) {
                newNatures.add(natureId);
            }
            ++n2;
        }
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        this.removeMavenBuilder(project, description, monitor);
        project.setDescription(description, monitor);
        MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(project, this.mavenConfiguration.isOffline(), false));
    }

    @Override
    public boolean addMavenBuilder(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        boolean setProjectDescription = false;
        if (description == null) {
            description = project.getDescription();
            setProjectDescription = true;
        }
        ICommand mavenBuilder = null;
        ArrayList<ICommand> newSpec = new ArrayList<ICommand>();
        int i = 0;
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (this.isMavenBuilderCommand(command)) {
                mavenBuilder = command;
                if (i == description.getBuildSpec().length - 1) {
                    return false;
                }
            } else {
                newSpec.add(command);
            }
            ++i;
            ++n2;
        }
        if (mavenBuilder == null) {
            mavenBuilder = description.newCommand();
            mavenBuilder.setBuilderName("org.eclipse.m2e.core.maven2Builder");
        }
        newSpec.add(mavenBuilder);
        description.setBuildSpec((ICommand[])newSpec.toArray(ICommand[]::new));
        if (setProjectDescription) {
            project.setDescription(description, monitor);
        }
        return true;
    }

    @Override
    public boolean removeMavenBuilder(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        boolean setProjectDescription = false;
        if (description == null) {
            description = project.getDescription();
            setProjectDescription = true;
        }
        boolean foundMavenBuilder = false;
        ArrayList<ICommand> newSpec = new ArrayList<ICommand>();
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!this.isMavenBuilderCommand(command)) {
                newSpec.add(command);
            } else {
                foundMavenBuilder = true;
            }
            ++n2;
        }
        if (!foundMavenBuilder) {
            return false;
        }
        description.setBuildSpec((ICommand[])newSpec.toArray(ICommand[]::new));
        if (setProjectDescription) {
            project.setDescription(description, monitor);
        }
        return true;
    }

    private boolean isMavenBuilderCommand(ICommand command) {
        return "org.eclipse.m2e.core.maven2Builder".equals(command.getBuilderName());
    }

    @Override
    public void createSimpleProject(IProject project, IPath location, Model model, List<String> directories, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        this.createSimpleProject(project, location, model, directories, configuration, null, monitor);
    }

    @Override
    public void createSimpleProject(IProject project, IPath location, Model model, List<String> directories, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        String projectName = project.getName();
        monitor.beginTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_creating, (Object)projectName), 5);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_workspace);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setLocation(location);
        project.create(description, monitor);
        project.open(monitor);
        monitor.worked(1);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_pom);
        IFile pomFile = project.getFile("pom.xml");
        this.mavenModelManager.createMavenModel(pomFile, model);
        monitor.worked(1);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_folders);
        for (String element : directories) {
            ProjectConfigurationManager.createFolder(project.getFolder(element), false);
        }
        monitor.worked(1);
        if (listener != null) {
            listener.projectCreated(project);
        }
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_project);
        this.enableMavenNature(project, configuration.getResolverConfiguration(), monitor);
        monitor.worked(1);
        IProject parent = this.findParentProject(model);
        if (parent != null) {
            this.hideNestedProjectsFromParents(Collections.singletonList(project), Collections.singletonList(parent), monitor);
            monitor.worked(1);
        }
    }

    private IProject findParentProject(Model model) {
        Parent parent = model.getParent();
        if (parent == null) {
            return null;
        }
        MavenProjectFacade parentProjectFacade = this.projectManager.getMavenProject(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        return parentProjectFacade == null ? null : parentProjectFacade.getProject();
    }

    public static void createFolder(IFolder folder, boolean derived) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent != null && !parent.exists()) {
                ProjectConfigurationManager.createFolder((IFolder)parent, false);
            }
            folder.create(true, true, null);
        }
        if (folder.isAccessible() && derived) {
            folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    log.info("Collecting project info {}", (Object)projectInfo);
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }

    @Override
    public ISchedulingRule getRule() {
        return ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
    }

    IProject create(MavenProjectInfo projectInfo, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        File pomFile = projectInfo.getPomFile();
        Model model = projectInfo.getModel();
        if (model == null) {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream pomStream = Files.newInputStream(pomFile.toPath(), new OpenOption[0]);){
                    model = IMavenToolbox.of(this.maven).readModel(pomStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                log.error(Messages.MavenImpl_error_read_pom, (Throwable)ex);
            }
            projectInfo.setModel(model);
        }
        if (model == null) {
            throw new IllegalStateException("Failed to load model of project " + String.valueOf(projectInfo));
        }
        model.setPomFile(pomFile);
        String projectName = ProjectConfigurationManager.getProjectName(configuration, model);
        File projectDir = pomFile.getParentFile();
        String projectParent = projectDir.getParentFile().getAbsolutePath();
        if (projectInfo.getBasedirRename() == 2) {
            File newProject = new File(projectDir.getParent(), projectName);
            if (!projectDir.equals(newProject)) {
                boolean renamed = projectDir.renameTo(newProject);
                if (!renamed) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(NLS.bind((String)Messages.ProjectConfigurationManager_error_rename, (Object)projectDir.getAbsolutePath())).append('.');
                    if (newProject.exists()) {
                        msg.append(NLS.bind((String)Messages.ProjectConfigurationManager_error_targetDir, (Object)newProject.getAbsolutePath()));
                    }
                    throw new CoreException(Status.error((String)msg.toString()));
                }
                projectInfo.setPomFile(this.getCanonicalPomFile(newProject));
                projectDir = newProject;
            }
        } else if (projectParent.equals(root.getLocation().toFile().getAbsolutePath())) {
            projectName = projectDir.getName();
        }
        monitor.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_importing2, (Object)projectName));
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            log.error("Project {} already exists", (Object)projectName);
            return null;
        }
        if (projectDir.equals(root.getLocation().toFile())) {
            log.error("Can't create project {} at Workspace folder", (Object)projectName);
            return null;
        }
        if (projectParent.equals(root.getLocation().toFile().getAbsolutePath())) {
            project.create(monitor);
        } else {
            IProjectDescription description = workspace.newProjectDescription(projectName);
            description.setLocation(IPath.fromOSString((String)projectDir.getAbsolutePath()));
            project.create(description, monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        if (listener != null) {
            listener.projectCreated(project);
        }
        ResolverConfiguration resolverConfiguration = configuration.getResolverConfiguration();
        this.enableBasicMavenNature(project, resolverConfiguration, monitor);
        LifecycleMappingConfiguration.persistEmpty(project);
        return project;
    }

    private File getCanonicalPomFile(File projectDir) throws CoreException {
        try {
            return new File(projectDir.getCanonicalFile(), "pom.xml");
        }
        catch (IOException ex) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.ProjectConfigurationManager_0, (Object)projectDir.getAbsolutePath())));
        }
    }

    @Override
    public void mavenProjectChanged(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        for (MavenProjectChangedEvent event : events) {
            try {
                IMavenProjectFacade facade = event.getMavenProject();
                ILifecycleMapping lifecycleMapping = this.getLifecycleMapping(facade);
                if (lifecycleMapping != null) {
                    for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(facade, monitor)) {
                        configurator.mavenProjectChanged(event, monitor);
                    }
                }
                if (facade != null) {
                    LifecycleMappingConfiguration oldConfiguration;
                    ProblemSeverity outOfDateSeverity = ProblemSeverity.get(this.mavenConfiguration.getOutOfDateProjectSeverity());
                    IProject project = facade.getProject();
                    this.mavenMarkerManager.deleteMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.configuration");
                    if (ProblemSeverity.ignore.equals((Object)outOfDateSeverity) || (oldConfiguration = LifecycleMappingConfiguration.restore(facade, monitor)) == null || !LifecycleMappingFactory.isLifecycleMappingChanged(facade, oldConfiguration, monitor)) continue;
                    if (!ResolverConfigurationIO.isAutomaticallyUpdateConfiguration(project)) {
                        outOfDateSeverity = ProblemSeverity.info;
                    }
                    this.mavenMarkerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.configuration", Messages.ProjectConfigurationUpdateRequired, -1, outOfDateSeverity.getSeverity());
                    continue;
                }
                IMavenProjectFacade oldFacade = event.getOldMavenProject();
                if (oldFacade == null) continue;
                this.mavenMarkerManager.deleteMarkers((IResource)oldFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.configuration");
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public ILifecycleMapping getLifecycleMapping(IMavenProjectFacade projectFacade) {
        if (projectFacade == null) {
            return null;
        }
        return LifecycleMappingFactory.getLifecycleMapping(projectFacade);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource iResource;
        if (event.getType() == 4 && (iResource = event.getResource()) instanceof IProject) {
            IProject project = (IProject)iResource;
            LifecycleMappingConfiguration.remove(project);
        }
    }

    @Override
    public ResolverConfiguration getResolverConfiguration(IProject project) {
        IProjectConfiguration cfg = ResolverConfigurationIO.readResolverConfiguration(project);
        if (cfg instanceof ResolverConfiguration) {
            return (ResolverConfiguration)cfg;
        }
        return new ResolverConfiguration(cfg);
    }

    @Override
    public IProjectConfiguration getProjectConfiguration(IProject project) {
        return ResolverConfigurationIO.readResolverConfiguration(project);
    }

    @Override
    public boolean setResolverConfiguration(IProject project, ResolverConfiguration configuration) {
        return ResolverConfigurationIO.saveResolverConfiguration(project, configuration);
    }

    @Override
    public IStatus updateProjectConfiguration(IProject project, IProjectConfiguration configuration, IProgressMonitor monitor) {
        if (ResolverConfigurationIO.saveResolverConfiguration(project, configuration)) {
            try {
                this.updateProjectConfiguration(project, monitor);
            }
            catch (CoreException ex) {
                return ex.getStatus();
            }
        }
        return Status.CANCEL_STATUS;
    }

    List<IProject> findExistingProjectsToHideFrom() {
        if (!MavenPlugin.getMavenConfiguration().isHideFoldersOfNestedProjects()) {
            return Collections.emptyList();
        }
        List<MavenProjectFacade> existingFacades = this.projectManager.getProjects();
        if (existingFacades == null || existingFacades.isEmpty()) {
            return Collections.emptyList();
        }
        return existingFacades.stream().map(IMavenProjectFacade::getProject).toList();
    }

    public static String getProjectName(ProjectImportConfiguration importConfig, Model model) {
        String name;
        String version;
        if (importConfig.getProjectNameTemplate().isEmpty()) {
            String cleanProjectNameComponent = ProjectConfigurationManager.cleanProjectNameComponent(model.getArtifactId(), false);
            if (cleanProjectNameComponent != null && !cleanProjectNameComponent.isEmpty()) {
                return cleanProjectNameComponent;
            }
            return model.getPomFile().getParentFile().getName();
        }
        String artifactId = model.getArtifactId();
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        if ((version = model.getVersion()) == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        if ((name = model.getName()) == null || name.trim().isEmpty()) {
            name = artifactId;
        }
        return importConfig.getProjectNameTemplate().replace(GROUP_ID, ProjectConfigurationManager.cleanProjectNameComponent(groupId, true)).replace(ARTIFACT_ID, ProjectConfigurationManager.cleanProjectNameComponent(artifactId, true)).replace(NAME, ProjectConfigurationManager.cleanProjectNameComponent(name, true)).replace(VERSION, version == null ? "" : ProjectConfigurationManager.cleanProjectNameComponent(version, true));
    }

    private static final String cleanProjectNameComponent(String value, boolean quote) {
        value = value.replaceAll("\\$\\{[^\\}]++\\}", "");
        if (quote) {
            value = Matcher.quoteReplacement(value);
        }
        return value;
    }

    private /* synthetic */ Map lambda$3(MavenUpdateRequest mavenUpdateRequest, boolean bl, boolean bl2, boolean bl3, IMavenExecutionContext context, IProgressMonitor m) throws CoreException {
        return this.updateProjectConfiguration0(mavenUpdateRequest.getPomFiles(), bl, bl2, bl3, m);
    }

    private /* synthetic */ boolean lambda$4(Map map, SubMonitor subMonitor, IMavenProjectFacade facade) {
        String projectName = facade.getProject().getName();
        IStatus status = (IStatus)map.get(projectName);
        if (status != null && !status.isOK()) {
            map.put(projectName, status);
            return true;
        }
        subMonitor.subTask(projectName);
        try {
            SubMonitor submonitor = subMonitor.split(1, 1);
            ProjectConfigurationRequest cfgRequest = new ProjectConfigurationRequest(facade, facade.getMavenProject((IProgressMonitor)submonitor));
            this.updateProjectConfiguration(cfgRequest, (IProgressMonitor)submonitor);
        }
        catch (CoreException ex) {
            map.put(projectName, ex.getStatus());
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$5(SubMonitor subMonitor, Map map, IMavenProjectFacade facade) {
        subMonitor.checkCanceled();
        IProject project = facade.getProject();
        subMonitor.subTask(project.getName());
        try {
            IStatus status = (IStatus)map.get(project.getName());
            if (status == null || status.isOK()) {
                project.build(15, (IProgressMonitor)subMonitor.split(1, 1));
            }
        }
        catch (CoreException ex) {
            map.put(project.getName(), ex.getStatus());
            return true;
        }
        return false;
    }
}

