/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.ui.editors.text.EditorsUI;

public class LSPFormatter {
    public CompletableFuture<Optional<VersionedEdits>> requestFormatting(IDocument document, ITextSelection textSelection) throws BadLocationException {
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(LSPFormatter::supportsFormatting);
        FormattingOptions formatOptions = LSPFormatter.getFormatOptions();
        TextDocumentIdentifier docId = new TextDocumentIdentifier(uri.toString());
        DocumentRangeFormattingParams rangeParams = LSPFormatter.getRangeFormattingParams(document, textSelection, formatOptions, docId);
        DocumentFormattingParams params = LSPFormatter.getFullFormatParams(formatOptions, docId);
        long modificationStamp = DocumentUtil.getDocumentModificationStamp(document);
        return executor.computeFirst((w, ls) -> w.getServerCapabilitiesAsync().thenCompose(capabilities -> {
            if (LSPFormatter.isDocumentRangeFormattingSupported(capabilities) && (textSelection.getLength() > 0 || !LSPFormatter.isDocumentFormattingSupported(capabilities))) {
                return ls.getTextDocumentService().rangeFormatting(rangeParams);
            }
            if (LSPFormatter.isDocumentFormattingSupported(capabilities)) {
                return ls.getTextDocumentService().formatting(params);
            }
            return CompletableFuture.completedFuture(null);
        })).thenApply(optionalEdits -> optionalEdits.map(edits -> new VersionedEdits(modificationStamp, (List<? extends TextEdit>)edits, document)));
    }

    public static DocumentFormattingParams getFullFormatParams(FormattingOptions formatOptions, TextDocumentIdentifier docId) {
        DocumentFormattingParams params = new DocumentFormattingParams();
        params.setTextDocument(docId);
        params.setOptions(formatOptions);
        return params;
    }

    public static DocumentRangeFormattingParams getRangeFormattingParams(IDocument document, ITextSelection textSelection, FormattingOptions formatOptions, TextDocumentIdentifier docId) throws BadLocationException {
        DocumentRangeFormattingParams rangeParams = new DocumentRangeFormattingParams();
        rangeParams.setTextDocument(docId);
        rangeParams.setOptions(formatOptions);
        boolean isFullFormat = textSelection.isEmpty() || textSelection.getLength() == 0;
        int startAt = isFullFormat ? 0 : textSelection.getOffset();
        int endAt = isFullFormat ? document.getLength() : startAt + textSelection.getLength();
        rangeParams.setRange(LSPEclipseUtils.toRange(startAt, endAt, document));
        return rangeParams;
    }

    public static FormattingOptions getFormatOptions() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        int tabWidth = store.getInt("tabWidth");
        boolean insertSpaces = store.getBoolean("spacesForTabs");
        return new FormattingOptions(tabWidth, insertSpaces);
    }

    public static boolean isDocumentRangeFormattingSupported(ServerCapabilities capabilities) {
        return LSPEclipseUtils.hasCapability(capabilities.getDocumentRangeFormattingProvider());
    }

    public static boolean isDocumentFormattingSupported(ServerCapabilities capabilities) {
        return LSPEclipseUtils.hasCapability(capabilities.getDocumentFormattingProvider());
    }

    public static boolean supportsFormatting(ServerCapabilities capabilities) {
        return LSPFormatter.isDocumentFormattingSupported(capabilities) || LSPFormatter.isDocumentRangeFormattingSupported(capabilities);
    }
}

