/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.filter.MetadataFilter;

public class CompositeMetadataFilter
extends MetadataFilter {
    private List<MetadataFilter> filters;

    public CompositeMetadataFilter() {
        this.filters = new ArrayList<MetadataFilter>();
    }

    public CompositeMetadataFilter(List<MetadataFilter> filters) {
        this.filters = filters;
    }

    public void setFilters(List<MetadataFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public List<MetadataFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void filter(Metadata metadata) throws TikaException {
        for (MetadataFilter filter : this.filters) {
            filter.filter(metadata);
        }
    }

    public String toString() {
        return "CompositeMetadataFilter{filters=" + String.valueOf(this.filters) + "}";
    }
}

