/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.annotation.EAnnotationItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaDataAnnotationValidator;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;

public final class ExtendedMetaDataAnnotationItemProviderAdapterFactory
extends EAnnotationItemProviderAdapterFactory {
    protected static final BasicEAnnotationValidator.Assistant ASSISTANT = ((BasicEAnnotationValidator)EAnnotationValidator.Registry.INSTANCE.getEAnnotationValidator("http:///org/eclipse/emf/ecore/util/ExtendedMetaData")).getAssistant();

    public ExtendedMetaDataAnnotationItemProviderAdapterFactory() {
        super((ResourceLocator)EcoreEditPlugin.INSTANCE, ASSISTANT);
    }

    @Override
    public IItemPropertyDescriptor getPropertyDescriptor(EObject eObject, String key, EStructuralFeature eStructuralFeature, EAnnotation eAnnotation, ResourceLocator resourceLocator) {
        final EObject context = eObject;
        String messageKey = String.valueOf(eStructuralFeature.getEContainingClass().getName()) + "_" + eStructuralFeature.getName();
        return new ItemPropertyDescriptor((AdapterFactory)this.getRootAdapterFactory(), resourceLocator, resourceLocator.getString("_UI_" + messageKey + "_feature"), resourceLocator.getString("_UI_" + messageKey + "_description"), eStructuralFeature, eStructuralFeature.isChangeable(), false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                EObject eObject = (EObject)object;
                if (this.feature instanceof EReference) {
                    EClassifier eType = this.feature.getEType();
                    if (eType == null) {
                        return null;
                    }
                    Collection result = 1.getReachableObjectsOfType((EObject)context, (EClassifier)eType);
                    if (!this.feature.isMany()) {
                        result.add(null);
                    }
                    return ExtendedMetaDataAnnotationValidator.INSTANCE.filterChoiceOfValues(eObject, this.feature, result);
                }
                if ("namespace".equals(this.feature.getName())) {
                    ResourceSet resourceSet;
                    Collection result = 1.getReachableObjectsOfType((EObject)context, (EClassifier)EcorePackage.Literals.EPACKAGE);
                    LinkedList eObjects = new LinkedList(result);
                    Resource resource = context.eResource();
                    if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                        HashSet visited = new HashSet(eObjects);
                        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                        for (String nsURI : packageRegistry.keySet()) {
                            1.collectReachableObjectsOfType(visited, eObjects, (EObject)packageRegistry.getEPackage(nsURI), (EClassifier)EcorePackage.Literals.EPACKAGE);
                        }
                    }
                    return ExtendedMetaDataAnnotationValidator.INSTANCE.filterChoiceOfValues(eObject, this.feature, eObjects);
                }
                if ("wildcards".equals(this.feature.getName())) {
                    ResourceSet resourceSet;
                    Collection ePackages = 1.getReachableObjectsOfType((EObject)context, (EClassifier)EcorePackage.Literals.EPACKAGE);
                    LinkedList eObjects = new LinkedList(ePackages);
                    Resource resource = context.eResource();
                    if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                        HashSet visited = new HashSet(eObjects);
                        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                        for (String nsURI : packageRegistry.keySet()) {
                            1.collectReachableObjectsOfType(visited, eObjects, (EObject)packageRegistry.getEPackage(nsURI), (EClassifier)EcorePackage.Literals.EPACKAGE);
                        }
                    }
                    return ExtendedMetaDataAnnotationValidator.INSTANCE.filterChoiceOfValues(eObject, this.feature, eObjects);
                }
                return ExtendedMetaDataAnnotationValidator.INSTANCE.filterChoiceOfValues(eObject, this.feature, super.getChoiceOfValues(object));
            }

            public boolean isChoiceArbitrary(Object object) {
                String name = this.feature.getName();
                return "namespace".equals(name) || "wildcards".equals(name);
            }
        };
    }

    @Override
    public IItemPropertyDescriptor createPropertyDescriptorDecorator(IItemPropertyDescriptor propertyDescriptor, EObject eObject, String key, EStructuralFeature eStructuralFeature, EAnnotation eAnnotation, ResourceLocator resourceLocator, EditingDomain domain) {
        return new ValuePropertyDescriptorDecorator(domain, eObject, propertyDescriptor, eAnnotation);
    }

    private static class ValuePropertyDescriptorDecorator
    extends ItemPropertyDescriptorDecorator {
        private final EAnnotation eAnnotation;
        private EditingDomain domain;

        private ValuePropertyDescriptorDecorator(EditingDomain domain, Object object, IItemPropertyDescriptor itemPropertyDescriptor, EAnnotation eAnnotation) {
            super(object, itemPropertyDescriptor);
            this.domain = domain;
            this.eAnnotation = eAnnotation;
        }

        public boolean isPropertyUnsettable(Object object) {
            return "name".equals(this.itemPropertyDescriptor.getId(object));
        }

        public void basicSetPropertyValue(Object object, Object value) {
            super.setPropertyValue(object, value);
        }

        public void basicResetPropertyValue(Object object) {
            super.resetPropertyValue(object);
        }

        public void resetPropertyValue(Object object) {
            ValueChangeCommand command = new ValueChangeCommand((Notifier)EcoreUtil.getRootContainer((EObject)this.eAnnotation), object, null);
            this.domain.getCommandStack().execute((Command)command);
        }

        public void setPropertyValue(Object object, Object value) {
            String id;
            if ("".equals(value) && ("minInclusive".equals(id = this.itemPropertyDescriptor.getId(object)) || "maxInclusive".equals(id) || "minExclusive".equals(id) || "maxExclusive".equals(id))) {
                return;
            }
            ValueChangeCommand command = new ValueChangeCommand((Notifier)EcoreUtil.getRootContainer((EObject)this.eAnnotation), object, value);
            this.domain.getCommandStack().execute((Command)command);
        }

        protected class ValueChangeCommand
        extends ChangeCommand {
            private final Object object;
            private final Object value;

            private ValueChangeCommand(Notifier notifier, Object object, Object value) {
                super(notifier);
                this.object = object;
                this.value = value;
            }

            protected void doExecute() {
                ArrayList<Map.Entry> originalPrecedingDetails = null;
                EMap details = ValuePropertyDescriptorDecorator.this.eAnnotation.getDetails();
                if (this.object instanceof Map.Entry) {
                    originalPrecedingDetails = new ArrayList<Map.Entry>();
                    for (Map.Entry entry : details) {
                        if (entry == this.object) break;
                        originalPrecedingDetails.add(entry);
                    }
                }
                if (this.value == null) {
                    ValuePropertyDescriptorDecorator.this.basicResetPropertyValue(this.object);
                } else {
                    ValuePropertyDescriptorDecorator.this.basicSetPropertyValue(this.object, this.value);
                }
                if (originalPrecedingDetails != null && !details.contains(this.object)) {
                    Map.Entry entry;
                    entry = (Map.Entry)this.object;
                    boolean added = false;
                    int i = 0;
                    int size = details.size();
                    while (i < size) {
                        if (!originalPrecedingDetails.contains(details.get(i))) {
                            details.add(i, (Object)entry);
                            added = true;
                            break;
                        }
                        ++i;
                    }
                    if (!added) {
                        details.add((Object)entry);
                    }
                    entry.setValue(this.value == null ? null : this.value.toString());
                }
            }

            public String getLabel() {
                return EcoreEditPlugin.INSTANCE.getString("_UI_ChangeExtendedMetaData_text");
            }

            public String getDescription() {
                return EcoreEditPlugin.INSTANCE.getString("_UI_ChangeExtendedMetaData_description");
            }

            public Collection<?> getAffectedObjects() {
                if (this.changeDescription != null) {
                    EList objectsToDetach = this.changeDescription.getObjectsToDetach();
                    if (!objectsToDetach.isEmpty()) {
                        return objectsToDetach;
                    }
                    return this.changeDescription.getObjectChanges().keySet();
                }
                return super.getAffectedObjects();
            }
        }
    }
}

