/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ForLoops;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class ArraysFillCleanUpCore
extends AbstractMultiFix {
    public ArraysFillCleanUpCore() {
        this(Collections.emptyMap());
    }

    public ArraysFillCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.arrays_fill");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.arrays_fill")) {
            return new String[]{MultiFixMessages.ArraysFillCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.arrays_fill")) {
            return "Arrays.fill(array, true);\n\n\n";
        }
        return "for (int i = 0; i < array.length; i++) {\n  array[i] = true;\n}\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.arrays_fill")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(ForStatement node) {
                ArrayAccess arrayAccess;
                ForLoops.ForLoopContent loopContent = ForLoops.iterateOverContainer(node);
                Assignment assignment = ASTNodes.asExpression(node.getBody(), Assignment.class);
                if (assignment != null && loopContent != null && loopContent.getLoopVariable() != null && loopContent.getContainerType() == ForLoops.ContainerType.ARRAY && ASTNodes.hasOperator(assignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0]) && this.isUnchangedValue(node, assignment.getRightHandSide()) && ASTNodes.isPassive((ASTNode)assignment.getRightHandSide()) && (arrayAccess = ASTNodes.as(assignment.getLeftHandSide(), ArrayAccess.class)) != null && this.isSameVariable(loopContent, arrayAccess) && this.areTypesCompatible(loopContent, assignment)) {
                    rewriteOperations.add(new ArraysFillOperation(node, assignment, arrayAccess));
                    return false;
                }
                return true;
            }

            private boolean areTypesCompatible(ForLoops.ForLoopContent loopContent, Assignment assignment) {
                return loopContent.getContainerVariable().resolveTypeBinding() != null && loopContent.getContainerVariable().resolveTypeBinding().getElementType() != null && (!ASTNodes.hasType(loopContent.getContainerVariable(), char[].class.getCanonicalName(), byte[].class.getCanonicalName(), short[].class.getCanonicalName()) || loopContent.getContainerVariable().resolveTypeBinding().getElementType().equals((Object)assignment.getRightHandSide().resolveTypeBinding()));
            }

            private boolean isUnchangedValue(ForStatement node, Expression expression) {
                IBinding binding;
                if (!ASTNodes.isPassive((ASTNode)expression)) {
                    return false;
                }
                if (ASTNodes.isHardCoded(expression)) {
                    return true;
                }
                SimpleName simpleName = null;
                if (expression instanceof QualifiedName) {
                    QualifiedName name = (QualifiedName)expression;
                    IBinding binding2 = name.getQualifier().resolveBinding();
                    if (binding2.getKind() == 2) {
                        simpleName = name.getName();
                    }
                } else if (expression instanceof SimpleName) {
                    simpleName = (SimpleName)expression;
                }
                if (simpleName != null && (binding = simpleName.resolveBinding()) instanceof IVariableBinding) {
                    IVariableBinding varBinding = (IVariableBinding)binding;
                    if (varBinding.isField()) {
                        return Modifier.isFinal(varBinding.getModifiers());
                    }
                    if (varBinding.isEffectivelyFinal()) {
                        return true;
                    }
                    ASTNode declaration = ASTNodes.findDeclaration(binding, expression.getRoot());
                    return declaration != null && !ASTNodes.isParent(declaration, (ASTNode)node);
                }
                return false;
            }

            private boolean isSameVariable(ForLoops.ForLoopContent loopContent, ArrayAccess arrayAccess) {
                return arrayAccess != null && ASTNodes.isSameVariable((ASTNode)arrayAccess.getArray(), (ASTNode)loopContent.getContainerVariable()) && ASTNodes.isSameLocalVariable(arrayAccess.getIndex(), (Expression)loopContent.getLoopVariable());
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.ArraysFillCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class ArraysFillOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final ForStatement node;
        private final Assignment assignment;
        private final ArrayAccess arrayAccess;

        public ArraysFillOperation(ForStatement node, Assignment assignment, ArrayAccess arrayAccess) {
            this.node = node;
            this.assignment = assignment;
            this.arrayAccess = arrayAccess;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ArraysFillCleanUp_description, cuRewrite);
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            String arraysNameText = importRewrite.addImport(Arrays.class.getCanonicalName());
            MethodInvocation methodInvocation = ast.newMethodInvocation();
            methodInvocation.setExpression((Expression)ASTNodeFactory.newName(ast, arraysNameText));
            methodInvocation.setName(ast.newSimpleName("fill"));
            methodInvocation.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.arrayAccess.getArray())));
            methodInvocation.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.assignment.getRightHandSide())));
            ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)methodInvocation);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.node, (ASTNode)expressionStatement, group);
        }
    }
}

