/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityURIConverter;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emf.resource.UnsupportedFeature;
import org.eclipse.wst.common.internal.emf.utilities.IDUtil;

public class MappedXMIHelper
extends XMLHelperImpl {
    private static final String WORKSPACE_PROTOCOL = "workspace:/";
    private static final String PLATFORM_RESOURCE_PROTOCOL = "platform:/resource/";
    private static final EStructuralFeature NULL_FEATURE = new UnsupportedFeature();
    protected boolean usingMaps = true;
    protected Map cachedRelativeURIs;
    protected Map packageURIsToPrefixes;

    public MappedXMIHelper(XMLResource resource, Map prefixesToURIs) {
        super(resource);
        this.prefixesToURIs.putAll(prefixesToURIs);
        this.pushContext();
        Set keys = prefixesToURIs.keySet();
        for (String prefix : keys) {
            String uri = (String)prefixesToURIs.get(prefix);
            this.namespaceSupport.declarePrefix(prefix, uri);
        }
    }

    public URI resolve(URI relative, URI base) {
        URI resolved = null;
        boolean isMapped = false;
        ResourceSet set = this.getResource().getResourceSet();
        if (set != null) {
            URI localresourceURI = null;
            localresourceURI = relative.hasFragment() ? relative.trimFragment() : relative;
            boolean bl = isMapped = !((URIConverterImpl.URIMap)set.getURIConverter().getURIMap()).getURI(localresourceURI).equals(localresourceURI);
        }
        if (!isMapped) {
            if (this.isUsingContainerRelativePaths() && set != null) {
                resolved = set.getURIConverter().normalize(relative);
            }
        } else {
            resolved = relative;
        }
        return resolved == null ? super.resolve(relative, base) : resolved;
    }

    private boolean isUsingContainerRelativePaths() {
        return ((CompatibilityXMIResource)this.resource).getFormat() == 1 || this.usingMaps;
    }

    public void addPrefix(String prefix, String uri) {
        String existing;
        if (uri.endsWith(".ecore")) {
            this.usingMaps = false;
        }
        if ((existing = (String)this.prefixesToURIs.get((Object)prefix)) == null) {
            this.prefixesToURIs.put((Object)prefix, (Object)uri);
            this.namespaceSupport.declarePrefix(prefix, uri);
        } else if (!existing.equals(uri)) {
            this.getCompatibilityResource().addOriginalPackageURI(existing, uri);
            this.getCompatibilityResource().setFormat(1);
        }
    }

    protected CompatibilityXMIResource getCompatibilityResource() {
        return (CompatibilityXMIResource)this.getResource();
    }

    public String getHREF(EObject obj) {
        URIConverter conv;
        if (!this.getCompatibilityResource().usesDefaultFormat() && (conv = this.getURIConverter()) != null && conv instanceof CompatibilityURIConverter) {
            String href = this.getCompatibliltyHREF(obj, (CompatibilityURIConverter)conv);
            return this.useWorkspaceProtocolIfNecessary(href);
        }
        return super.getHREF(obj);
    }

    protected String useWorkspaceProtocolIfNecessary(String href) {
        if (href != null && href.startsWith(PLATFORM_RESOURCE_PROTOCOL)) {
            return WORKSPACE_PROTOCOL + href.substring(19);
        }
        return href;
    }

    private String getCompatibliltyHREF(EObject obj, CompatibilityURIConverter conv) {
        InternalEObject o = (InternalEObject)obj;
        URI objectURI = o.eProxyURI();
        if (objectURI == null) {
            Resource otherResource = obj.eResource();
            if (otherResource == null) {
                objectURI = this.handleDanglingHREF(obj);
                if (objectURI == null) {
                    return null;
                }
            } else {
                objectURI = otherResource.getURI().appendFragment(otherResource.getURIFragment(obj));
            }
        }
        if (!objectURI.isRelative()) {
            objectURI = this.makeRelative(objectURI, conv);
        }
        return objectURI.toString();
    }

    protected URI makeRelative(URI objectURI, CompatibilityURIConverter conv) {
        URI innerObjectURI = objectURI;
        String fragment = innerObjectURI.fragment();
        innerObjectURI = innerObjectURI.trimFragment();
        URI relative = (URI)this.getCachedRelativeURIs().get(innerObjectURI);
        if (relative == null && (relative = conv.deNormalize(innerObjectURI)).isRelative()) {
            this.cachedRelativeURIs.put(innerObjectURI, relative);
        }
        return relative.appendFragment(fragment);
    }

    protected URIConverter getURIConverter() {
        ResourceSet set = this.getResource().getResourceSet();
        if (set != null) {
            return set.getURIConverter();
        }
        return null;
    }

    protected Map getCachedRelativeURIs() {
        if (this.cachedRelativeURIs == null) {
            this.cachedRelativeURIs = new HashMap();
        }
        return this.cachedRelativeURIs;
    }

    public String getID(EObject obj) {
        if (this.getCompatibilityResource().usesDefaultFormat()) {
            return super.getID(obj);
        }
        return IDUtil.getOrAssignID(obj, this.resource);
    }

    public String[] getNSInfo(EPackage pkg) {
        String prefix = this.getMappedPrefix(pkg);
        if (prefix == null) {
            return new String[]{pkg.getNsPrefix(), pkg.getNsURI()};
        }
        return new String[]{prefix, prefix + ".xmi"};
    }

    protected String getMappedPrefix(EPackage pkg) {
        String nsURI = pkg.getNsURI();
        if (this.usingMaps || !this.getCompatibilityResource().usesDefaultFormat()) {
            return (String)this.packageURIsToPrefixes.get(nsURI);
        }
        return null;
    }

    protected String getMappedPrefixOrDefault(EPackage pkg) {
        String prefix = this.getMappedPrefix(pkg);
        return prefix == null ? pkg.getNsPrefix() : prefix;
    }

    public Map getPackageURIsToPrefixes() {
        return this.packageURIsToPrefixes;
    }

    public void setPackageURIsToPrefixes(Map packageURIsToPrefixes) {
        this.packageURIsToPrefixes = packageURIsToPrefixes;
    }

    public String getQName(EClass c) {
        XMLResource.XMLInfo clsInfo;
        String name = this.getName((ENamedElement)c);
        if (this.xmlMap != null && (clsInfo = this.xmlMap.getInfo((ENamedElement)c)) != null) {
            String targetNamespace = clsInfo.getTargetNamespace();
            return this.getQName(targetNamespace, name);
        }
        EPackage p = c.getEPackage();
        this.packages.put(p, null);
        if (p.getNsPrefix().equals("")) {
            return name;
        }
        return this.getMappedPrefixOrDefault(p) + ":" + name;
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (feature == NULL_FEATURE) {
            return;
        }
        if (!feature.isTransient()) {
            if (value == null && feature.getEType().getInstanceClass() != null && feature.getEType().getInstanceClass().isPrimitive()) {
                return;
            }
            super.setValue(object, feature, value, position);
        }
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name, boolean isElement) {
        if (UnsupportedFeature.isUnsupported(eClass, name)) {
            return NULL_FEATURE;
        }
        return super.getFeature(eClass, namespaceURI, name, isElement);
    }

    public int getFeatureKind(EStructuralFeature feature) {
        if (feature == NULL_FEATURE) {
            return 1;
        }
        return super.getFeatureKind(feature);
    }
}

