/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.openon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.openon.IOpenOn;
import org.osgi.framework.Bundle;

public class OpenOnDefinition {
    private String fClassName = null;
    private IConfigurationElement fConfigurationElement = null;
    private HashMap fContentTypes = null;
    private String fId = null;

    public OpenOnDefinition(String id, String class1, IConfigurationElement configurationElement) {
        this.fId = id;
        this.fClassName = class1;
        this.fConfigurationElement = configurationElement;
        this.fContentTypes = new HashMap();
    }

    public void addContentTypeId(String contentTypeId) {
        if (!this.fContentTypes.containsKey(contentTypeId)) {
            this.fContentTypes.put(contentTypeId, new ArrayList());
        }
    }

    public void addPartitionType(String contentTypeId, String partitionType) {
        if (!this.fContentTypes.containsKey(contentTypeId)) {
            this.fContentTypes.put(contentTypeId, new ArrayList());
        }
        List partitionList = (List)this.fContentTypes.get(contentTypeId);
        partitionList.add(partitionType);
    }

    private Object createExtension(String propertyName) {
        final IConfigurationElement element = this.getConfigurationElement();
        final String name = propertyName;
        final Object[] result = new Object[1];
        String pluginId = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle.getState() == 32) {
            try {
                return element.createExecutableExtension(name);
            }
            catch (CoreException e) {
                this.handleCreateExecutableException(result, e);
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        result[0] = element.createExecutableExtension(name);
                    }
                    catch (Exception e) {
                        OpenOnDefinition.this.handleCreateExecutableException(result, e);
                    }
                }
            });
        }
        return result[0];
    }

    public IOpenOn createOpenOn() {
        IOpenOn openOn = null;
        if (this.getClassName() != null) {
            openOn = (IOpenOn)this.createExtension("class");
        }
        return openOn;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    public HashMap getContentTypes() {
        return this.fContentTypes;
    }

    public String getId() {
        return this.fId;
    }

    private void handleCreateExecutableException(Object[] result, Throwable e) {
        Logger.logException("Unable to create open on: " + this.getId(), e);
        e.printStackTrace();
        result[0] = null;
    }
}

